/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiMatchFieldId;
import org.onosproject.net.pi.model.PiMatchType;
import org.onosproject.net.pi.runtime.PiExactFieldMatch;

public class PiExactFieldMatchTest {
    private final ImmutableByteSequence value1 = ImmutableByteSequence.copyFrom((int)2048);
    private final ImmutableByteSequence value2 = ImmutableByteSequence.copyFrom((int)2054);
    private final PiMatchFieldId piMatchField = PiMatchFieldId.of((String)"ethernet_t.etherType");
    private PiExactFieldMatch piExactFieldMatch1 = new PiExactFieldMatch(this.piMatchField, this.value1);
    private PiExactFieldMatch sameAsPiExactFieldMatch1 = new PiExactFieldMatch(this.piMatchField, this.value1);
    private PiExactFieldMatch piExactFieldMatch2 = new PiExactFieldMatch(this.piMatchField, this.value2);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiExactFieldMatch.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piExactFieldMatch1, this.sameAsPiExactFieldMatch1}).addEqualityGroup(new Object[]{this.piExactFieldMatch2}).testEquals();
    }

    @Test
    public void testConstruction() {
        ImmutableByteSequence value = ImmutableByteSequence.copyFrom((int)2054);
        PiMatchFieldId piMatchField = PiMatchFieldId.of((String)"ethernet_t.etherType");
        PiExactFieldMatch piExactFieldMatch = new PiExactFieldMatch(piMatchField, value);
        MatcherAssert.assertThat((Object)piExactFieldMatch, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)piExactFieldMatch.value(), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat((Object)piExactFieldMatch.type(), (Matcher)Matchers.is((Object)PiMatchType.EXACT));
    }
}

