/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource;

import com.google.common.testing.EqualsTester;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.VlanId;
import org.onlab.util.Bandwidth;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.resource.ContinuousResource;
import org.onosproject.net.resource.Resources;

public class ContinuousResourceTest {
    private static final DeviceId D1 = DeviceId.deviceId((String)"of:001");
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final Bandwidth BW1 = Bandwidth.gbps((long)2L);

    @Test
    public void testEquals() {
        ContinuousResource resource1 = Resources.continuous((DeviceId)D1, (PortNumber)P1, Bandwidth.class).resource(BW1.bps());
        ContinuousResource sameAsResource1 = Resources.continuous((DeviceId)D1, (PortNumber)P1, Bandwidth.class).resource(BW1.bps());
        new EqualsTester().addEqualityGroup(new Object[]{resource1, sameAsResource1}).testEquals();
    }

    @Test
    public void testTypeOf() {
        ContinuousResource continuous = Resources.continuous((DeviceId)D1, (PortNumber)P1, Bandwidth.class).resource(BW1.bps());
        Assert.assertThat((Object)continuous.isTypeOf(DeviceId.class), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)continuous.isTypeOf(PortNumber.class), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)continuous.isTypeOf(Bandwidth.class), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testSubTypeOf() {
        ContinuousResource continuous = Resources.continuous((DeviceId)D1, (PortNumber)P1, Bandwidth.class).resource(BW1.bps());
        Assert.assertThat((Object)continuous.isSubTypeOf(DeviceId.class), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)continuous.isSubTypeOf(PortNumber.class), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)continuous.isSubTypeOf(Bandwidth.class), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)continuous.isSubTypeOf(VlanId.class), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testSubTypeOfObject() {
        ContinuousResource continuous = Resources.continuous((DeviceId)D1, (PortNumber)P1, Bandwidth.class).resource(BW1.bps());
        Assert.assertThat((Object)continuous.isSubTypeOf(Object.class), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testValueAsPrimitiveDouble() {
        ContinuousResource resource = Resources.continuous((DeviceId)D1, (PortNumber)P1, Bandwidth.class).resource(BW1.bps());
        Optional volume = resource.valueAs(Double.TYPE);
        Assert.assertThat(volume.get(), (Matcher)Matchers.is((Object)BW1.bps()));
    }

    @Test
    public void testValueAsDouble() {
        ContinuousResource resource = Resources.continuous((DeviceId)D1, (PortNumber)P1, Bandwidth.class).resource(BW1.bps());
        Optional value = resource.valueAs(Double.class);
        Assert.assertThat(value.get(), (Matcher)Matchers.is((Object)BW1.bps()));
    }

    @Test
    public void testValueAsObject() {
        ContinuousResource resource = Resources.continuous((DeviceId)D1, (PortNumber)P1, Bandwidth.class).resource(BW1.bps());
        Optional value = resource.valueAs(Double.class);
        Assert.assertThat(value.get(), (Matcher)Matchers.is((Object)BW1.bps()));
    }

    @Test
    public void testValueAsIncompatibleType() {
        ContinuousResource resource = Resources.continuous((DeviceId)D1, (PortNumber)P1, Bandwidth.class).resource(BW1.bps());
        Optional value = resource.valueAs(VlanId.class);
        Assert.assertThat((Object)value, (Matcher)Matchers.is(Optional.empty()));
    }
}

