/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.util.Bandwidth;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.resource.ContinuousResourceId;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resources;

public class ResourceIdTest {
    private static final DeviceId D1 = DeviceId.deviceId((String)"a");
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final Bandwidth BW1 = Bandwidth.gbps((long)1L);

    @Test
    public void testDiscreteToString() {
        DiscreteResourceId resource = Resources.discrete((DeviceId)D1, (PortNumber)P1, (Object[])new Object[0]).id();
        Assert.assertThat((Object)resource.toString(), (Matcher)Matchers.is((Object)Arrays.asList(D1, P1).toString()));
    }

    @Test
    public void testContinuousToString() {
        ContinuousResourceId resource = Resources.continuous((DeviceId)D1, (PortNumber)P1, Bandwidth.class).id();
        Assert.assertThat((Object)resource.toString(), (Matcher)Matchers.is((Object)Arrays.asList(D1, P1, Bandwidth.class.getSimpleName()).toString()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitWithNonClassInstance() {
        Resources.continuous((DeviceId)D1, (PortNumber)P1, (Object[])new Object[]{BW1}).id();
    }
}

