/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.topology;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.graph.ScalarWeight;
import org.onlab.graph.Weight;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultDisjointPath;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.DisjointPath;
import org.onosproject.net.ElementId;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.Path;
import org.onosproject.net.host.HostServiceAdapter;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.AbstractPathService;
import org.onosproject.net.topology.LinkWeigher;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyEdge;
import org.onosproject.net.topology.TopologyServiceAdapter;

public class AbstractPathServiceTest {
    private TestPathService service;
    private FakeTopoMgr topoMgr;
    private ConnectPoint cpA = NetTestTools.connectPoint("A", 1);
    private ConnectPoint cpB = NetTestTools.connectPoint("B", 2);
    private ConnectPoint cpC = NetTestTools.connectPoint("C", 3);
    private ProviderId pid = ProviderId.NONE;
    private Link link1 = DefaultLink.builder().providerId(this.pid).src(this.cpA).dst(this.cpB).type(Link.Type.DIRECT).state(Link.State.ACTIVE).build();
    private Link link2 = DefaultLink.builder().providerId(this.pid).src(this.cpB).dst(this.cpC).type(Link.Type.DIRECT).state(Link.State.ACTIVE).build();
    private List<Link> links1 = ImmutableList.of((Object)this.link1, (Object)this.link2);
    private Path path1 = new DefaultPath(this.pid, this.links1, (Weight)new ScalarWeight(1.0), new Annotations[0]);

    @Before
    public void setUp() {
        this.service = new TestPathService();
        this.topoMgr = new FakeTopoMgr();
        this.service.topologyService = this.topoMgr;
        this.service.hostService = new HostServiceAdapter();
    }

    private void checkPathValues(Path path) {
        MatcherAssert.assertThat((Object)path, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)path.links(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((Link)path.links().get(0)).src(), (Matcher)Matchers.is((Object)this.cpA));
        MatcherAssert.assertThat((Object)((Link)path.links().get(0)).dst(), (Matcher)Matchers.is((Object)this.cpB));
        MatcherAssert.assertThat((Object)((Link)path.links().get(1)).src(), (Matcher)Matchers.is((Object)this.cpB));
        MatcherAssert.assertThat((Object)((Link)path.links().get(1)).dst(), (Matcher)Matchers.is((Object)this.cpC));
    }

    private void checkDisjointPaths(Set<DisjointPath> paths) {
        MatcherAssert.assertThat(paths, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat(paths, (Matcher)Matchers.hasSize((int)1));
        Path path = (Path)paths.iterator().next();
        this.checkPathValues(path);
    }

    private void checkPaths(Collection<Path> paths) {
        MatcherAssert.assertThat(paths, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat(paths, (Matcher)Matchers.hasSize((int)1));
        Path path = paths.iterator().next();
        this.checkPathValues(path);
    }

    @Test
    public void testNoPaths() {
        Set noPaths = this.service.getPaths((ElementId)NetTestTools.did("A"), (ElementId)NetTestTools.did("B"), new TestWeigher());
        MatcherAssert.assertThat((Object)noPaths, (Matcher)Matchers.empty());
    }

    @Test
    public void testSelfPaths() {
        HostId host = NetTestTools.hid("12:34:56:78:90:ab/1");
        Set paths = this.service.getPaths((ElementId)host, (ElementId)host, new TestWeigher());
        MatcherAssert.assertThat((Object)paths, (Matcher)Matchers.hasSize((int)1));
        Path path = (Path)paths.iterator().next();
        MatcherAssert.assertThat((Object)path, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)path.links(), (Matcher)Matchers.hasSize((int)2));
        Link link1 = (Link)path.links().get(0);
        Link link2 = (Link)path.links().get(1);
        MatcherAssert.assertThat((Object)link1.src(), (Matcher)Matchers.is((Object)link2.dst()));
        MatcherAssert.assertThat((Object)link2.src(), (Matcher)Matchers.is((Object)link1.dst()));
        MatcherAssert.assertThat((Object)link1.src().hostId(), (Matcher)Matchers.is((Object)host));
        MatcherAssert.assertThat((Object)link2.dst().hostId(), (Matcher)Matchers.is((Object)host));
    }

    @Test
    public void testDevicePaths() {
        this.topoMgr.definePaths((Set<Path>)ImmutableSet.of((Object)this.path1));
        Set pathsAC = this.service.getPaths((ElementId)NetTestTools.did("A"), (ElementId)NetTestTools.did("C"), new TestWeigher());
        this.checkPaths(pathsAC);
    }

    @Test
    public void testKShortestPath() {
        this.topoMgr.definePaths((Set<Path>)ImmutableSet.of((Object)this.path1));
        List<Path> paths = this.service.getKShortestPaths((ElementId)NetTestTools.did("A"), (ElementId)NetTestTools.did("C"), new TestWeigher()).collect(Collectors.toList());
        this.checkPaths(paths);
    }

    @Test
    public void testDisjointPaths() {
        this.topoMgr.definePaths((Set<Path>)ImmutableSet.of((Object)this.path1));
        Set paths = this.service.getDisjointPaths((ElementId)NetTestTools.did("A"), (ElementId)NetTestTools.did("C"), new TestWeigher());
        this.checkDisjointPaths(paths);
    }

    @Test
    public void testDisjointPathsWithRiskProfile() {
        this.topoMgr.definePaths((Set<Path>)ImmutableSet.of((Object)this.path1));
        ImmutableMap riskProfile = ImmutableMap.of();
        Set paths = this.service.getDisjointPaths((ElementId)NetTestTools.did("A"), (ElementId)NetTestTools.did("C"), new TestWeigher(), (Map)riskProfile);
        this.checkDisjointPaths(paths);
    }

    private class FakeTopoMgr
    extends TopologyServiceAdapter {
        Set<Path> paths = new HashSet<Path>();
        Set<DisjointPath> disjointPaths = new HashSet<DisjointPath>();

        private FakeTopoMgr() {
        }

        void definePaths(Set<Path> paths) {
            this.paths = paths;
            this.disjointPaths = paths.stream().map(path -> new DefaultDisjointPath(path.providerId(), (DefaultPath)path)).collect(Collectors.toSet());
        }

        @Override
        public Set<Path> getPaths(Topology topology, DeviceId src, DeviceId dst) {
            return this.paths;
        }

        @Override
        public Set<Path> getPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeigher weight) {
            return this.paths;
        }

        @Override
        public Set<DisjointPath> getDisjointPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeigher weigher) {
            return this.disjointPaths;
        }

        @Override
        public Set<DisjointPath> getDisjointPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeigher weigher, Map<Link, Object> riskProfile) {
            return this.disjointPaths;
        }
    }

    class TestWeigher
    implements LinkWeigher {
        TestWeigher() {
        }

        public Weight weight(TopologyEdge edge) {
            return new ScalarWeight(1.0);
        }

        public Weight getInitialWeight() {
            return new ScalarWeight(1.0);
        }

        public Weight getNonViableWeight() {
            return new ScalarWeight(0.0);
        }
    }

    private class TestPathService
    extends AbstractPathService {
        Set<Path> paths = null;
        Set<DisjointPath> disjointPaths = null;

        private TestPathService() {
        }

        public Set<Path> getPaths(ElementId src, ElementId dst) {
            return this.paths;
        }

        public Set<DisjointPath> getDisjointPaths(ElementId src, ElementId dst) {
            return this.disjointPaths;
        }

        public Set<DisjointPath> getDisjointPaths(ElementId src, ElementId dst, Map<Link, Object> riskProfile) {
            return this.disjointPaths;
        }
    }
}

