/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.onosproject.store.primitives.NodeUpdate;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.service.AsyncDocumentTree;
import org.onosproject.store.service.DocumentPath;
import org.onosproject.store.service.DocumentTree;
import org.onosproject.store.service.DocumentTreeListener;
import org.onosproject.store.service.TestDocumentTree;
import org.onosproject.store.service.TransactionLog;
import org.onosproject.store.service.Version;
import org.onosproject.store.service.Versioned;

public class TestAsyncDocumentTree<V>
implements AsyncDocumentTree<V> {
    private final DocumentTree<V> tree;

    public TestAsyncDocumentTree(String name) {
        this.tree = new TestDocumentTree(name);
    }

    public String name() {
        return this.tree.name();
    }

    public DocumentPath root() {
        return this.tree.root();
    }

    public CompletableFuture<Map<String, Versioned<V>>> getChildren(DocumentPath path) {
        return CompletableFuture.completedFuture(this.tree.getChildren(path));
    }

    public CompletableFuture<Versioned<V>> get(DocumentPath path) {
        return CompletableFuture.completedFuture(this.tree.get(path));
    }

    public CompletableFuture<Versioned<V>> set(DocumentPath path, V value) {
        return CompletableFuture.completedFuture(this.tree.set(path, value));
    }

    public CompletableFuture<Boolean> create(DocumentPath path, V value) {
        return CompletableFuture.completedFuture(this.tree.create(path, value));
    }

    public CompletableFuture<Boolean> createRecursive(DocumentPath path, V value) {
        return CompletableFuture.completedFuture(this.tree.createRecursive(path, value));
    }

    public CompletableFuture<Boolean> replace(DocumentPath path, V newValue, long version) {
        return CompletableFuture.completedFuture(this.tree.replace(path, newValue, version));
    }

    public CompletableFuture<Boolean> replace(DocumentPath path, V newValue, V currentValue) {
        return CompletableFuture.completedFuture(this.tree.replace(path, newValue, currentValue));
    }

    public CompletableFuture<Versioned<V>> removeNode(DocumentPath path) {
        return CompletableFuture.completedFuture(this.tree.removeNode(path));
    }

    public CompletableFuture<Void> addListener(DocumentPath path, DocumentTreeListener<V> listener) {
        this.tree.addListener(path, listener);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> removeListener(DocumentTreeListener<V> listener) {
        this.tree.removeListener(listener);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Version> begin(TransactionId transactionId) {
        return null;
    }

    public CompletableFuture<Boolean> prepare(TransactionLog<NodeUpdate<V>> transactionLog) {
        return null;
    }

    public CompletableFuture<Boolean> prepareAndCommit(TransactionLog<NodeUpdate<V>> transactionLog) {
        return null;
    }

    public CompletableFuture<Void> commit(TransactionId transactionId) {
        return null;
    }

    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        return null;
    }

    public DocumentTree<V> asDocumentTree() {
        return this.tree;
    }
}

