/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.onosproject.store.primitives.DefaultDistributedSet;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetAdapter;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.SetEvent;
import org.onosproject.store.service.SetEventListener;

public final class TestDistributedSet<E>
extends DistributedSetAdapter<E> {
    private final List<SetEventListener<E>> listeners;
    private final Set<E> set = Sets.newConcurrentHashSet();
    private final String setName;

    public TestDistributedSet(String setName) {
        this.listeners = new LinkedList<SetEventListener<E>>();
        this.setName = setName;
    }

    private void notifyListeners(SetEvent<E> event) {
        this.listeners.forEach(listener -> listener.event(event));
    }

    @Override
    public CompletableFuture<Void> addListener(SetEventListener<E> listener) {
        this.listeners.add(listener);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeListener(SetEventListener<E> listener) {
        this.listeners.remove(listener);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Boolean> add(E element) {
        boolean updated = this.set.add(element);
        if (updated) {
            SetEvent event = new SetEvent(this.setName, SetEvent.Type.ADD, element);
            this.notifyListeners(event);
        }
        return CompletableFuture.completedFuture(updated);
    }

    @Override
    public CompletableFuture<Boolean> remove(E element) {
        boolean updated = this.set.remove(element);
        if (updated) {
            SetEvent event = new SetEvent(this.setName, SetEvent.Type.REMOVE, element);
            this.notifyListeners(event);
        }
        return CompletableFuture.completedFuture(updated);
    }

    @Override
    public CompletableFuture<Integer> size() {
        return CompletableFuture.completedFuture(this.set.size());
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        return CompletableFuture.completedFuture(this.set.isEmpty());
    }

    @Override
    public CompletableFuture<Void> clear() {
        this.removeAll((Collection<? extends E>)ImmutableSet.copyOf(this.set));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Boolean> contains(E element) {
        return CompletableFuture.completedFuture(this.set.contains(element));
    }

    @Override
    public CompletableFuture<Boolean> addAll(Collection<? extends E> c) {
        return c.stream().map(this::add).reduce(CompletableFuture.completedFuture(false), (l, r) -> l.thenCombine((CompletionStage)r, Boolean::logicalOr));
    }

    @Override
    public CompletableFuture<Boolean> containsAll(Collection<? extends E> c) {
        return CompletableFuture.completedFuture(this.set.containsAll(c));
    }

    @Override
    public CompletableFuture<Boolean> retainAll(Collection<? extends E> c) {
        Set s = c instanceof Set ? (Set)c : ImmutableSet.copyOf(c);
        Sets.SetView notInSet2 = Sets.difference(this.set, (Set)s);
        return this.removeAll((Collection<? extends E>)ImmutableSet.copyOf((Collection)notInSet2));
    }

    @Override
    public CompletableFuture<Boolean> removeAll(Collection<? extends E> c) {
        return c.stream().map(this::remove).reduce(CompletableFuture.completedFuture(false), (l, r) -> l.thenCombine((CompletionStage)r, Boolean::logicalOr));
    }

    @Override
    public CompletableFuture<? extends Set<E>> getAsImmutableSet() {
        return CompletableFuture.completedFuture(ImmutableSet.copyOf(this.set));
    }

    @Override
    public String name() {
        return this.setName;
    }

    public DistributedSet<E> asDistributedSet() {
        return new DefaultDistributedSet((AsyncDistributedSet)this, 0L);
    }

    public DistributedSet<E> asDistributedSet(long timeoutMillis) {
        return new DefaultDistributedSet((AsyncDistributedSet)this, timeoutMillis);
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static class Builder<E>
    extends DistributedSetBuilder<E> {
        public AsyncDistributedSet<E> build() {
            return new TestDistributedSet(this.name());
        }
    }
}

