/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.ui.UiExtension;
import org.onosproject.ui.UiMessageHandlerFactory;
import org.onosproject.ui.UiTopoOverlayFactory;
import org.onosproject.ui.UiView;
import org.onosproject.ui.UiViewHidden;

public class UiExtensionTest {
    private static final String FOO_ID = "foo";
    private static final String FOO_LABEL = "Foo View";
    private static final String BAR_ID = "bar";
    private static final String BAR_LABEL = "Bar View";
    private static final String CUSTOM = "custom";
    private static final UiView FOO_VIEW = new UiView(UiView.Category.OTHER, "foo", "Foo View");
    private static final UiView BAR_VIEW = new UiView(UiView.Category.OTHER, "bar", "Bar View");
    private static final UiView HIDDEN_VIEW = new UiViewHidden("foo");
    private static final UiMessageHandlerFactory MH_FACTORY = () -> null;
    private static final UiTopoOverlayFactory TO_FACTORY = () -> null;
    private final ClassLoader cl = this.getClass().getClassLoader();
    private List<UiView> viewList;
    private UiExtension ext;
    private String css;
    private String js;
    private UiView view;

    @Test
    public void basics() throws IOException {
        this.viewList = ImmutableList.of((Object)FOO_VIEW);
        this.ext = new UiExtension.Builder(this.cl, this.viewList).build();
        this.css = new String(ByteStreams.toByteArray((InputStream)this.ext.css()));
        Assert.assertTrue((String)"incorrect css stream", (boolean)this.css.contains("foo-css"));
        this.js = new String(ByteStreams.toByteArray((InputStream)this.ext.js()));
        Assert.assertTrue((String)"incorrect js stream", (boolean)this.js.contains("foo-js"));
        Assert.assertEquals((String)"expected 1 view", (long)1L, (long)this.ext.views().size());
        this.view = (UiView)this.ext.views().get(0);
        Assert.assertEquals((String)"wrong view category", (Object)UiView.Category.OTHER, (Object)this.view.category());
        Assert.assertEquals((String)"wrong view id", (Object)FOO_ID, (Object)this.view.id());
        Assert.assertEquals((String)"wrong view label", (Object)FOO_LABEL, (Object)this.view.label());
        Assert.assertNull((String)"unexpected message handler factory", (Object)this.ext.messageHandlerFactory());
        Assert.assertNull((String)"unexpected topo overlay factory", (Object)this.ext.topoOverlayFactory());
    }

    @Test
    public void withPath() throws IOException {
        this.viewList = ImmutableList.of((Object)FOO_VIEW);
        this.ext = new UiExtension.Builder(this.cl, this.viewList).resourcePath(CUSTOM).build();
        this.css = new String(ByteStreams.toByteArray((InputStream)this.ext.css()));
        Assert.assertTrue((String)"incorrect css stream", (boolean)this.css.contains("custom-css"));
        this.js = new String(ByteStreams.toByteArray((InputStream)this.ext.js()));
        Assert.assertTrue((String)"incorrect js stream", (boolean)this.js.contains("custom-js"));
        Assert.assertEquals((String)"expected 1 view", (long)1L, (long)this.ext.views().size());
        this.view = (UiView)this.ext.views().get(0);
        Assert.assertEquals((String)"wrong view category", (Object)UiView.Category.OTHER, (Object)this.view.category());
        Assert.assertEquals((String)"wrong view id", (Object)FOO_ID, (Object)this.view.id());
        Assert.assertEquals((String)"wrong view label", (Object)FOO_LABEL, (Object)this.view.label());
        Assert.assertNull((String)"unexpected message handler factory", (Object)this.ext.messageHandlerFactory());
        Assert.assertNull((String)"unexpected topo overlay factory", (Object)this.ext.topoOverlayFactory());
    }

    @Test
    public void messageHandlerFactory() {
        this.viewList = ImmutableList.of((Object)FOO_VIEW);
        this.ext = new UiExtension.Builder(this.cl, this.viewList).messageHandlerFactory(MH_FACTORY).build();
        Assert.assertEquals((String)"wrong message handler factory", (Object)MH_FACTORY, (Object)this.ext.messageHandlerFactory());
        Assert.assertNull((String)"unexpected topo overlay factory", (Object)this.ext.topoOverlayFactory());
    }

    @Test
    public void topoOverlayFactory() {
        this.viewList = ImmutableList.of((Object)HIDDEN_VIEW);
        this.ext = new UiExtension.Builder(this.cl, this.viewList).topoOverlayFactory(TO_FACTORY).build();
        Assert.assertNull((String)"unexpected message handler factory", (Object)this.ext.messageHandlerFactory());
        Assert.assertEquals((String)"wrong topo overlay factory", (Object)TO_FACTORY, (Object)this.ext.topoOverlayFactory());
    }

    @Test
    public void twoViews() {
        this.viewList = ImmutableList.of((Object)FOO_VIEW, (Object)BAR_VIEW);
        this.ext = new UiExtension.Builder(this.cl, this.viewList).build();
        Assert.assertEquals((String)"expected 2 views", (long)2L, (long)this.ext.views().size());
        this.view = (UiView)this.ext.views().get(0);
        Assert.assertEquals((String)"wrong view category", (Object)UiView.Category.OTHER, (Object)this.view.category());
        Assert.assertEquals((String)"wrong view id", (Object)FOO_ID, (Object)this.view.id());
        Assert.assertEquals((String)"wrong view label", (Object)FOO_LABEL, (Object)this.view.label());
        this.view = (UiView)this.ext.views().get(1);
        Assert.assertEquals((String)"wrong view category", (Object)UiView.Category.OTHER, (Object)this.view.category());
        Assert.assertEquals((String)"wrong view id", (Object)BAR_ID, (Object)this.view.id());
        Assert.assertEquals((String)"wrong view label", (Object)BAR_LABEL, (Object)this.view.label());
    }
}

