/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.chart;

import org.junit.Assert;
import org.junit.Test;
import org.onosproject.ui.chart.ChartModel;

public class ChartModelTest {
    private static final String FOO = "foo";
    private static final String BAR = "bar";
    private static final String ZOO = "zoo";
    private static final Double[] VALUES1 = new Double[]{0.0, 1.0, 2.0};
    private static final Double[] VALUES2 = new Double[]{3.0, 4.0, 5.0};
    private static final Double[] VALUES3 = new Double[]{6.0, 7.0, 8.0};
    private ChartModel cm;

    @Test(expected=NullPointerException.class)
    public void guardAgainstNullSeries() {
        this.cm = new ChartModel((String[])null);
    }

    @Test
    public void testSeriesCount() {
        this.cm = new ChartModel(new String[]{FOO, BAR, ZOO});
        Assert.assertEquals((String)"Wrong series count", (long)3L, (long)this.cm.seriesCount());
    }

    @Test
    public void emptyLabel() {
        this.cm = new ChartModel(new String[]{FOO, BAR, ZOO});
        this.cm.addDataPoint((Object)System.currentTimeMillis());
        Assert.assertEquals((String)"bad data point count", (long)1L, (long)this.cm.dataPointCount());
    }

    @Test(expected=IllegalArgumentException.class)
    public void dataPointBandSeries() {
        this.cm = new ChartModel(new String[]{FOO, BAR});
        this.cm.addDataPoint((Object)System.currentTimeMillis()).data(ZOO, (Object)VALUES3[0]);
    }

    @Test
    public void testAddDataPoint() {
        this.cm = new ChartModel(new String[]{FOO, BAR, ZOO});
        long time = System.currentTimeMillis();
        this.cm.addDataPoint((Object)time).data(FOO, (Object)VALUES1[0]).data(BAR, (Object)VALUES2[0]).data(ZOO, (Object)VALUES3[0]);
        this.cm.addDataPoint((Object)(time + 1L)).data(FOO, (Object)VALUES1[1]).data(BAR, (Object)VALUES2[1]).data(ZOO, (Object)VALUES3[1]);
        this.cm.addDataPoint((Object)(time + 2L)).data(FOO, (Object)VALUES1[2]).data(BAR, (Object)VALUES2[2]).data(ZOO, (Object)VALUES3[2]);
        Assert.assertEquals((String)"Wrong result", (long)3L, (long)this.cm.getDataPoints()[0].size());
        Assert.assertEquals((String)"Wrong result", (long)3L, (long)this.cm.getDataPoints()[1].size());
        Assert.assertEquals((String)"Wrong result", (long)3L, (long)this.cm.getDataPoints()[2].size());
        Assert.assertEquals((String)"Wrong result", (long)3L, (long)this.cm.getDataPoints().length);
    }

    @Test
    public void testGetDataPoint() {
        this.cm = new ChartModel(new String[]{FOO, BAR});
        long time = System.currentTimeMillis();
        this.cm.addDataPoint((Object)time).data(FOO, (Object)VALUES1[0]).data(BAR, (Object)VALUES2[0]);
        this.cm.addDataPoint((Object)(time + 1L)).data(FOO, (Object)VALUES1[1]).data(BAR, (Object)VALUES2[1]);
        Assert.assertEquals((String)"Wrong result", (Object)0.0, (Object)this.cm.getDataPoints()[0].get(FOO));
        Assert.assertEquals((String)"Wrong result", (Object)1.0, (Object)this.cm.getDataPoints()[1].get(FOO));
        Assert.assertEquals((String)"Wrong result", (Object)3.0, (Object)this.cm.getDataPoints()[0].get(BAR));
        Assert.assertEquals((String)"Wrong result", (Object)4.0, (Object)this.cm.getDataPoints()[1].get(BAR));
    }

    @Test
    public void testGetLastDataPoint() {
        this.cm = new ChartModel(new String[]{FOO, BAR});
        long time = System.currentTimeMillis();
        this.cm.addDataPoint((Object)time).data(FOO, (Object)VALUES1[0]).data(BAR, (Object)VALUES2[0]);
        this.cm.addDataPoint((Object)(time + 1L)).data(FOO, (Object)VALUES1[1]).data(BAR, (Object)VALUES2[1]);
        Assert.assertEquals((String)"Wrong result", (Object)VALUES1[1], (Object)this.cm.getLastDataPoint().get(FOO));
        Assert.assertEquals((String)"Wrong result", (Object)VALUES2[1], (Object)this.cm.getLastDataPoint().get(BAR));
    }
}

