/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;

public class ClusterEventTest {
    private final NodeId node1 = new NodeId("1");
    private final NodeId node2 = new NodeId("2");
    private final IpAddress ip1 = IpAddress.valueOf((String)"10.0.0.1");
    private final IpAddress ip2 = IpAddress.valueOf((String)"10.0.0.2");
    private final ControllerNode cNode1 = new DefaultControllerNode(this.node1, this.ip1);
    private final ControllerNode cNode2 = new DefaultControllerNode(this.node2, this.ip2);
    private final ClusterEvent event1 = new ClusterEvent(ClusterEvent.Type.INSTANCE_ADDED, this.cNode1);
    private final ClusterEvent event2 = new ClusterEvent(ClusterEvent.Type.INSTANCE_REMOVED, this.cNode1);
    private final ClusterEvent event3 = new ClusterEvent(ClusterEvent.Type.INSTANCE_ACTIVATED, this.cNode1);
    private final ClusterEvent event4 = new ClusterEvent(ClusterEvent.Type.INSTANCE_READY, this.cNode1);
    private final ClusterEvent event5 = new ClusterEvent(ClusterEvent.Type.INSTANCE_DEACTIVATED, this.cNode1);
    private final ClusterEvent event6 = new ClusterEvent(ClusterEvent.Type.INSTANCE_ADDED, this.cNode2);
    private final long time = System.currentTimeMillis();
    private final ClusterEvent event7 = new ClusterEvent(ClusterEvent.Type.INSTANCE_READY, this.cNode2, this.time);
    private final ClusterEvent sameAsEvent7 = new ClusterEvent(ClusterEvent.Type.INSTANCE_READY, this.cNode2, this.time);

    @Test
    public void checkEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.event1}).addEqualityGroup(new Object[]{this.event2}).addEqualityGroup(new Object[]{this.event3}).addEqualityGroup(new Object[]{this.event4}).addEqualityGroup(new Object[]{this.event5}).addEqualityGroup(new Object[]{this.event6}).addEqualityGroup(new Object[]{this.event7, this.sameAsEvent7}).testEquals();
    }

    @Test
    public void checkConstruction() {
        Assert.assertThat((Object)this.event1.type(), (Matcher)Matchers.is((Object)ClusterEvent.Type.INSTANCE_ADDED));
        Assert.assertThat((Object)this.event1.subject(), (Matcher)Matchers.is((Object)this.cNode1));
        Assert.assertThat((Object)this.event7.time(), (Matcher)Matchers.is((Object)this.time));
        Assert.assertThat((Object)this.event7.type(), (Matcher)Matchers.is((Object)ClusterEvent.Type.INSTANCE_READY));
        Assert.assertThat((Object)this.event7.subject(), (Matcher)Matchers.is((Object)this.cNode2));
    }
}

