/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import com.google.common.testing.EqualsTester;
import com.spotify.hamcrest.optional.OptionalMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.behaviour.DefaultTunnelDescription;
import org.onosproject.net.behaviour.TunnelDescription;
import org.onosproject.net.behaviour.TunnelEndPoint;
import org.onosproject.net.behaviour.TunnelKey;

public class DefaultTunnelDescriptionTest {
    private static final String DID_1 = "device1";
    private static final String IFACE_NAME_1 = "eth1";
    private static final TunnelKey<Long> KEY_1 = new TunnelKey((Object)1L);
    private static final TunnelEndPoint<Long> LOCAL_1 = new TunnelEndPoint((Object)11L);
    private static final TunnelEndPoint<Long> REMOTE_1 = new TunnelEndPoint((Object)12L);
    private static final SparseAnnotations ANNOTATIONS_1 = DefaultAnnotations.builder().set("AAA", "AAA").build();
    private TunnelDescription tunnelDescription1 = DefaultTunnelDescription.builder().deviceId("device1").ifaceName("eth1").key(KEY_1).type(TunnelDescription.Type.GRE).local(LOCAL_1).remote(REMOTE_1).otherConfigs(ANNOTATIONS_1).build();
    private TunnelDescription tunnelDescription2 = DefaultTunnelDescription.builder().deviceId("device1").ifaceName("eth1").key(KEY_1).type(TunnelDescription.Type.GRE).remote(LOCAL_1).local(REMOTE_1).build();

    @Test
    public void testConstruction() {
        Assert.assertThat((Object)this.tunnelDescription1.deviceId(), (Matcher)OptionalMatchers.optionalWithValue((Matcher)Matchers.is((Object)DID_1)));
        Assert.assertThat((Object)this.tunnelDescription1.ifaceName(), (Matcher)Matchers.is((Object)IFACE_NAME_1));
        Assert.assertThat((Object)this.tunnelDescription1.key(), (Matcher)OptionalMatchers.optionalWithValue((Matcher)Matchers.is(KEY_1)));
        Assert.assertThat((Object)this.tunnelDescription1.type(), (Matcher)Matchers.is((Object)TunnelDescription.Type.GRE));
        Assert.assertThat((Object)this.tunnelDescription1.local(), (Matcher)OptionalMatchers.optionalWithValue((Matcher)Matchers.is(LOCAL_1)));
        Assert.assertThat((Object)this.tunnelDescription1.remote(), (Matcher)OptionalMatchers.optionalWithValue((Matcher)Matchers.is(REMOTE_1)));
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.tunnelDescription1}).addEqualityGroup(new Object[]{this.tunnelDescription2}).testEquals();
    }
}

