/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.packet;

import com.google.common.testing.EqualsTester;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.packet.DefaultPacketRequest;
import org.onosproject.net.packet.PacketPriority;

public class DefaultPacketRequestTest {
    private final TrafficSelector selector = DefaultTrafficSelector.builder().matchIcmpCode((byte)1).build();
    private final DefaultPacketRequest packetRequest1 = new DefaultPacketRequest(DefaultTrafficSelector.emptySelector(), PacketPriority.CONTROL, NetTestTools.APP_ID, NetTestTools.NODE_ID, Optional.empty());
    private final DefaultPacketRequest sameAsacketRequest1 = new DefaultPacketRequest(DefaultTrafficSelector.emptySelector(), PacketPriority.CONTROL, NetTestTools.APP_ID, NetTestTools.NODE_ID, Optional.empty());
    private final DefaultPacketRequest packetRequest2 = new DefaultPacketRequest(this.selector, PacketPriority.CONTROL, NetTestTools.APP_ID, NetTestTools.NODE_ID, Optional.empty());
    private final DefaultPacketRequest packetRequest3 = new DefaultPacketRequest(DefaultTrafficSelector.emptySelector(), PacketPriority.REACTIVE, NetTestTools.APP_ID, NetTestTools.NODE_ID, Optional.empty());
    private final DefaultPacketRequest packetRequest4 = new DefaultPacketRequest(DefaultTrafficSelector.emptySelector(), PacketPriority.CONTROL, (ApplicationId)new DefaultApplicationId(1, "foo"), new NodeId("node1"), Optional.empty());

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.packetRequest1, this.sameAsacketRequest1}).addEqualityGroup(new Object[]{this.packetRequest2}).addEqualityGroup(new Object[]{this.packetRequest3}).addEqualityGroup(new Object[]{this.packetRequest4}).testEquals();
    }

    @Test
    public void testConstruction() {
        MatcherAssert.assertThat((Object)this.packetRequest1.priority(), (Matcher)Matchers.is((Object)PacketPriority.CONTROL));
        MatcherAssert.assertThat((Object)this.packetRequest1.priority().priorityValue(), (Matcher)Matchers.is((Object)PacketPriority.CONTROL.priorityValue()));
        MatcherAssert.assertThat((Object)this.packetRequest1.selector(), (Matcher)Matchers.is((Object)DefaultTrafficSelector.emptySelector()));
        MatcherAssert.assertThat((Object)this.packetRequest1.appId(), (Matcher)Matchers.is((Object)NetTestTools.APP_ID));
    }

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(DefaultPacketRequest.class);
    }
}

