/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.statistic;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.statistic.DefaultLoad;

public class DefaultLoadTest {
    @Before
    public void reset() {
        DefaultLoad.setPollInterval((long)10L);
    }

    @Test
    public void testDefaultConstructor() {
        DefaultLoad load = new DefaultLoad();
        MatcherAssert.assertThat((Object)load.isValid(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)load.latest(), (Matcher)Matchers.is((Object)-1L));
        MatcherAssert.assertThat((Object)load.rate(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)load.time(), (Matcher)Matchers.is((Matcher)IsNot.not((Object)0)));
    }

    @Test
    public void testCurrentPreviousConstructor() {
        DefaultLoad load = new DefaultLoad(20L, 10L);
        MatcherAssert.assertThat((Object)load.isValid(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)load.latest(), (Matcher)Matchers.is((Object)20L));
        MatcherAssert.assertThat((Object)load.rate(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)load.time(), (Matcher)Matchers.is((Matcher)IsNot.not((Object)0)));
    }

    @Test
    public void testCurrentPreviousIntervalConstructor() {
        DefaultLoad load = new DefaultLoad(20L, 10L, 1L);
        MatcherAssert.assertThat((Object)load.isValid(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)load.latest(), (Matcher)Matchers.is((Object)20L));
        MatcherAssert.assertThat((Object)load.rate(), (Matcher)Matchers.is((Object)10L));
        MatcherAssert.assertThat((Object)load.time(), (Matcher)Matchers.is((Matcher)IsNot.not((Object)0)));
    }

    @Test
    public void testToString() {
        DefaultLoad load = new DefaultLoad(20L, 10L);
        String s = load.toString();
        MatcherAssert.assertThat((Object)s, (Matcher)Matchers.containsString((String)"Load{rate=1, latest=20}"));
    }

    @Test
    public void testSettingPollInterval() {
        DefaultLoad.setPollInterval((long)1L);
        DefaultLoad load = new DefaultLoad(40L, 10L);
        MatcherAssert.assertThat((Object)load.rate(), (Matcher)Matchers.is((Object)30L));
    }
}

