/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.ui.topo.LinkHighlight;
import org.onosproject.ui.topo.Mod;

public class LinkHighlightTest {
    private static final String LINK_ID = "link-id-for-testing";
    private static final String LABEL = "some label";
    private static final String EMPTY = "";
    private static final String CUSTOM = "custom";
    private static final String ANIMATED = "animated";
    private static final String OPTICAL = "optical";
    private LinkHighlight lh;

    @Test
    public void basic() {
        this.lh = new LinkHighlight(LINK_ID, LinkHighlight.Flavor.NO_HIGHLIGHT);
        Assert.assertEquals((String)"wrong flavor", (Object)LinkHighlight.Flavor.NO_HIGHLIGHT, (Object)this.lh.flavor());
        Assert.assertTrue((String)"unexpected mods", (boolean)this.lh.mods().isEmpty());
        Assert.assertEquals((String)"wrong css", (Object)"plain", (Object)this.lh.cssClasses());
        Assert.assertEquals((String)"wrong label", (Object)EMPTY, (Object)this.lh.label());
    }

    @Test
    public void primaryOptical() {
        this.lh = new LinkHighlight(LINK_ID, LinkHighlight.Flavor.PRIMARY_HIGHLIGHT).addMod(LinkHighlight.MOD_OPTICAL);
        Assert.assertEquals((String)"wrong flavor", (Object)LinkHighlight.Flavor.PRIMARY_HIGHLIGHT, (Object)this.lh.flavor());
        Assert.assertEquals((String)"missing mod", (long)1L, (long)this.lh.mods().size());
        Mod m = (Mod)this.lh.mods().iterator().next();
        Assert.assertEquals((String)"wrong mod", (Object)LinkHighlight.MOD_OPTICAL, (Object)m);
        Assert.assertEquals((String)"wrong css", (Object)"primary optical", (Object)this.lh.cssClasses());
        Assert.assertEquals((String)"wrong label", (Object)EMPTY, (Object)this.lh.label());
    }

    @Test
    public void secondaryAnimatedWithLabel() {
        this.lh = new LinkHighlight(LINK_ID, LinkHighlight.Flavor.SECONDARY_HIGHLIGHT).addMod(LinkHighlight.MOD_ANIMATED).setLabel(LABEL);
        Assert.assertEquals((String)"wrong flavor", (Object)LinkHighlight.Flavor.SECONDARY_HIGHLIGHT, (Object)this.lh.flavor());
        Assert.assertEquals((String)"missing mod", (long)1L, (long)this.lh.mods().size());
        Mod m = (Mod)this.lh.mods().iterator().next();
        Assert.assertEquals((String)"wrong mod", (Object)LinkHighlight.MOD_ANIMATED, (Object)m);
        Assert.assertEquals((String)"wrong css", (Object)"secondary animated", (Object)this.lh.cssClasses());
        Assert.assertEquals((String)"wrong label", (Object)LABEL, (Object)this.lh.label());
    }

    @Test
    public void customMod() {
        this.lh = new LinkHighlight(LINK_ID, LinkHighlight.Flavor.PRIMARY_HIGHLIGHT).addMod(new Mod(CUSTOM));
        Assert.assertEquals((String)"missing mod", (long)1L, (long)this.lh.mods().size());
        Mod m = (Mod)this.lh.mods().iterator().next();
        Assert.assertEquals((String)"wrong mod", (Object)CUSTOM, (Object)m.toString());
        Assert.assertEquals((String)"wrong css", (Object)"primary custom", (Object)this.lh.cssClasses());
    }

    @Test
    public void severalMods() {
        this.lh = new LinkHighlight(LINK_ID, LinkHighlight.Flavor.SECONDARY_HIGHLIGHT).addMod(LinkHighlight.MOD_OPTICAL).addMod(LinkHighlight.MOD_ANIMATED).addMod(new Mod(CUSTOM));
        Assert.assertEquals((String)"missing mods", (long)3L, (long)this.lh.mods().size());
        Iterator iter = this.lh.mods().iterator();
        Assert.assertEquals((String)"wrong mod", (Object)ANIMATED, (Object)((Mod)iter.next()).toString());
        Assert.assertEquals((String)"wrong mod", (Object)CUSTOM, (Object)((Mod)iter.next()).toString());
        Assert.assertEquals((String)"wrong mod", (Object)OPTICAL, (Object)((Mod)iter.next()).toString());
        Assert.assertEquals((String)"wrong css", (Object)"secondary animated custom optical", (Object)this.lh.cssClasses());
    }

    @Test(expected=NullPointerException.class)
    public void noFlavor() {
        new LinkHighlight(LINK_ID, null);
    }

    @Test(expected=NullPointerException.class)
    public void noIdentity() {
        new LinkHighlight(null, LinkHighlight.Flavor.PRIMARY_HIGHLIGHT);
    }
}

