/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum ControlProtocolVersion {
    OF_1_0("OpenFlow10"),
    OF_1_1("OpenFlow11"),
    OF_1_2("OpenFlow12"),
    OF_1_3("OpenFlow13"),
    OF_1_4("OpenFlow14"),
    OF_1_5("OpenFlow15");

    private final String versionString;

    private ControlProtocolVersion(String versionString) {
        this.versionString = versionString;
    }

    public String toString() {
        return this.versionString;
    }

    public static List<String> toStringList() {
        return Arrays.stream(ControlProtocolVersion.values()).map(ControlProtocolVersion::toString).collect(Collectors.toCollection(ArrayList::new));
    }

    public static ControlProtocolVersion enumFromString(String versionString) {
        if (versionString != null && !versionString.isEmpty()) {
            for (ControlProtocolVersion c : ControlProtocolVersion.values()) {
                if (!versionString.equalsIgnoreCase(c.toString())) continue;
                return c;
            }
        }
        return null;
    }
}

