/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.collect.ImmutableSet;
import com.google.common.testing.EqualsTester;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.cluster.DefaultPartition;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.Partition;
import org.onosproject.cluster.PartitionId;
import org.onosproject.core.Version;

public class DefaultPartitionTest {
    NodeId id1 = new NodeId("1");
    NodeId id2 = new NodeId("2");
    NodeId id3 = new NodeId("3");
    PartitionId pid1 = new PartitionId(1);
    PartitionId pid2 = new PartitionId(2);
    PartitionId pid3 = new PartitionId(3);
    DefaultPartition partition1 = new DefaultPartition(this.pid1, Version.version((String)"1.0.0"), (Collection)ImmutableSet.of((Object)this.id1));
    DefaultPartition sameAsPartition1 = new DefaultPartition(this.pid1, Version.version((String)"1.0.0"), (Collection)ImmutableSet.of((Object)this.id1));
    DefaultPartition partition2 = new DefaultPartition(this.pid2, Version.version((String)"1.0.0"), (Collection)ImmutableSet.of((Object)this.id2));
    DefaultPartition copyOfPartition2 = new DefaultPartition((Partition)this.partition2);
    DefaultPartition partition3 = new DefaultPartition(this.pid3, Version.version((String)"1.0.0"), (Collection)ImmutableSet.of((Object)this.id1, (Object)this.id2, (Object)this.id3));

    @Test
    public void checkImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutableBaseClass(DefaultPartition.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.partition1, this.sameAsPartition1}).addEqualityGroup(new Object[]{this.partition2, this.copyOfPartition2}).addEqualityGroup(new Object[]{this.partition3}).testEquals();
    }

    @Test
    public void testConstruction() {
        Collection members = this.partition3.getMembers();
        MatcherAssert.assertThat((Object)members, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)members, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)members, (Matcher)Matchers.contains((Object[])new NodeId[]{this.id1, this.id2, this.id3}));
        MatcherAssert.assertThat((Object)this.partition3.getId(), (Matcher)Matchers.is((Object)this.pid3));
    }

    @Test
    public void testEmptyConstructor() {
        DefaultPartition empty = new DefaultPartition();
        MatcherAssert.assertThat((Object)empty.getId(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)empty.getMembers(), (Matcher)Matchers.nullValue());
    }
}

