/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.trafficcontrol;

import com.google.common.base.Strings;
import java.net.URI;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.behaviour.trafficcontrol.PolicerId;

public class PolicerIdTest {
    private static final String FOO_SCHEME = "foo";
    private static final String OF_SCHEME = "of";
    private static final Short ONE = 1;
    private static final Short TWO = 15;
    private static final String A = "A";
    private static final String LA = "a";
    @Rule
    public ExpectedException exceptionWrongId = ExpectedException.none();

    @Test
    public void testfromUriCreation() {
        URI uriOne = URI.create("of:" + Integer.toHexString(ONE.shortValue()));
        PolicerId one = PolicerId.policerId((URI)uriOne);
        Assert.assertThat((Object)one, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)one.id(), (Matcher)Matchers.is((Object)uriOne.toString().toLowerCase()));
        Assert.assertThat((Object)one.uri(), (Matcher)Matchers.is((Object)uriOne));
    }

    @Test
    public void testfromStringCreation() {
        String stringTwo = "of:" + Integer.toHexString(TWO.shortValue());
        PolicerId two = PolicerId.policerId((String)stringTwo);
        Assert.assertThat((Object)two, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)two.id(), (Matcher)Matchers.is((Object)stringTwo));
        Assert.assertThat((Object)two.uri(), (Matcher)Matchers.is((Object)URI.create(stringTwo)));
    }

    @Test
    public void testWrongCreation() {
        String wrongString = Strings.repeat((String)"x", (int)1025);
        this.exceptionWrongId.expect(IllegalArgumentException.class);
        PolicerId.policerId((String)wrongString);
    }

    @Test
    public void testEquality() {
        URI uriOne = URI.create("of:" + Integer.toHexString(ONE.shortValue()));
        String stringOne = "of:" + Integer.toHexString(ONE.shortValue());
        String stringTwo = "of:" + Integer.toHexString(TWO.shortValue());
        String stringA = "foo:A";
        String stringLA = "foo:a";
        PolicerId one = PolicerId.policerId((URI)uriOne);
        PolicerId copyOfOne = PolicerId.policerId((String)stringOne);
        Assert.assertEquals((Object)one, (Object)copyOfOne);
        PolicerId two = PolicerId.policerId((String)stringTwo);
        Assert.assertNotEquals((Object)two, (Object)one);
        Assert.assertNotEquals((Object)two, (Object)copyOfOne);
        PolicerId a = PolicerId.policerId((String)A);
        PolicerId la = PolicerId.policerId((String)LA);
        Assert.assertNotEquals((Object)a, (Object)la);
    }

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PolicerId.class);
    }
}

