/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.testing.EqualsTester;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.core.IdGenerator;
import org.onosproject.net.intent.AbstractIntentTest;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.IntentTestsMocks;
import org.onosproject.store.Timestamp;

public class IntentDataTest
extends AbstractIntentTest {
    private Timestamp timestamp1;
    private Timestamp timestamp2;
    private Timestamp timestamp3;
    private Intent intent1;
    private Intent intent2;
    private Intent intent3;
    private IntentData data1;
    private IntentData data1Copy;
    private IntentData data2;
    private IntentData data2Copy;
    private IntentData data3;
    private IntentData data3Copy;
    IdGenerator idGenerator;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.timestamp1 = new IntentTestsMocks.MockTimestamp(1);
        this.timestamp2 = new IntentTestsMocks.MockTimestamp(2);
        this.timestamp3 = new IntentTestsMocks.MockTimestamp(3);
        this.intent1 = new IntentTestsMocks.MockIntent(1L);
        this.intent2 = new IntentTestsMocks.MockIntent(2L);
        this.intent3 = new IntentTestsMocks.MockIntent(3L);
        this.data1 = new IntentData(this.intent1, IntentState.INSTALLED, this.timestamp1);
        this.data1Copy = new IntentData(this.intent1, IntentState.INSTALLED, this.timestamp1);
        this.data2 = new IntentData(this.intent2, IntentState.INSTALLED, this.timestamp2);
        this.data2Copy = new IntentData(this.intent2, IntentState.INSTALLED, this.timestamp2);
        this.data3 = new IntentData(this.intent3, IntentState.INSTALLED, this.timestamp3);
        this.data3Copy = new IntentData(this.intent3, IntentState.INSTALLED, this.timestamp3);
    }

    @Test
    public void checkConstruction() {
        MatcherAssert.assertThat((Object)this.data1.state(), (Matcher)Matchers.is((Object)IntentState.INSTALLED));
        MatcherAssert.assertThat((Object)this.data1.version(), (Matcher)Matchers.is((Object)this.timestamp1));
        MatcherAssert.assertThat((Object)this.data1.intent(), (Matcher)Matchers.is((Object)this.intent1));
    }

    @Test
    public void checkEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.data1, this.data1Copy}).addEqualityGroup(new Object[]{this.data2, this.data2Copy}).addEqualityGroup(new Object[]{this.data3, this.data3Copy}).testEquals();
    }

    @Test
    public void testIsUpdateAcceptable() {
        Assert.assertTrue((boolean)IntentData.isUpdateAcceptable(null, (IntentData)this.data1));
        Assert.assertTrue((boolean)IntentData.isUpdateAcceptable((IntentData)this.data1, (IntentData)this.data2));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)this.data2, (IntentData)this.data1));
        IntentData installing = new IntentData(this.intent1, IntentState.INSTALLING, this.timestamp1);
        IntentData installed = IntentData.nextState((IntentData)installing, (IntentState)IntentState.INSTALLED);
        IntentData withdrawing = new IntentData(this.intent1, IntentState.WITHDRAWING, this.timestamp1);
        IntentData withdrawn = IntentData.nextState((IntentData)withdrawing, (IntentState)IntentState.WITHDRAWN);
        IntentData failed = new IntentData(this.intent1, IntentState.FAILED, this.timestamp1);
        IntentData compiling = new IntentData(this.intent1, IntentState.COMPILING, this.timestamp1);
        IntentData recompiling = new IntentData(this.intent1, IntentState.RECOMPILING, this.timestamp1);
        IntentData installReq = new IntentData(this.intent1, IntentState.INSTALL_REQ, this.timestamp2);
        IntentData withdrawReq = new IntentData(this.intent1, IntentState.WITHDRAW_REQ, this.timestamp2);
        IntentData purgeReq = new IntentData(this.intent1, IntentState.PURGE_REQ, this.timestamp2);
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)installing, (IntentData)installing));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)installed, (IntentData)installed));
        Assert.assertTrue((boolean)IntentData.isUpdateAcceptable((IntentData)installing, (IntentData)installed));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)installed, (IntentData)installing));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)installing, (IntentData)withdrawing));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)installing, (IntentData)withdrawn));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)installed, (IntentData)withdrawing));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)installed, (IntentData)withdrawn));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)withdrawing, (IntentData)withdrawing));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)withdrawn, (IntentData)withdrawn));
        Assert.assertTrue((boolean)IntentData.isUpdateAcceptable((IntentData)withdrawing, (IntentData)withdrawn));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)withdrawing, (IntentData)installing));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)withdrawing, (IntentData)installed));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)withdrawn, (IntentData)installing));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)withdrawn, (IntentData)installed));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)failed, (IntentData)failed));
        Assert.assertTrue((boolean)IntentData.isUpdateAcceptable((IntentData)installing, (IntentData)IntentData.nextState((IntentData)installing, (IntentState)IntentState.FAILED)));
        Assert.assertTrue((boolean)IntentData.isUpdateAcceptable((IntentData)installed, (IntentData)IntentData.nextState((IntentData)installed, (IntentState)IntentState.FAILED)));
        Assert.assertTrue((boolean)IntentData.isUpdateAcceptable((IntentData)withdrawing, (IntentData)IntentData.nextState((IntentData)withdrawing, (IntentState)IntentState.FAILED)));
        Assert.assertTrue((boolean)IntentData.isUpdateAcceptable((IntentData)withdrawn, (IntentData)IntentData.nextState((IntentData)withdrawn, (IntentState)IntentState.FAILED)));
        Assert.assertTrue((boolean)IntentData.isUpdateAcceptable((IntentData)installing, (IntentData)purgeReq));
        Assert.assertTrue((boolean)IntentData.isUpdateAcceptable((IntentData)installed, (IntentData)purgeReq));
        Assert.assertTrue((boolean)IntentData.isUpdateAcceptable((IntentData)withdrawing, (IntentData)purgeReq));
        Assert.assertTrue((boolean)IntentData.isUpdateAcceptable((IntentData)withdrawn, (IntentData)purgeReq));
        Assert.assertTrue((boolean)IntentData.isUpdateAcceptable((IntentData)failed, (IntentData)purgeReq));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)purgeReq, (IntentData)withdrawn));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)purgeReq, (IntentData)withdrawing));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)purgeReq, (IntentData)installed));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)purgeReq, (IntentData)installing));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)installing, (IntentData)compiling));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)installing, (IntentData)recompiling));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)installing, (IntentData)installing));
        TestCase.assertFalse((boolean)IntentData.isUpdateAcceptable((IntentData)installing, (IntentData)withdrawing));
    }
}

