/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mastership;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.util.Tools;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.event.AbstractEvent;
import org.onosproject.mastership.MastershipInfo;
import org.onosproject.net.DeviceId;

public class MastershipEvent
extends AbstractEvent<Type, DeviceId> {
    private final MastershipInfo mastershipInfo;

    public MastershipEvent(Type type, DeviceId device, MastershipInfo mastershipInfo) {
        super(type, device);
        this.mastershipInfo = mastershipInfo;
    }

    public MastershipEvent(Type type, DeviceId device, MastershipInfo mastershipInfo, long time) {
        super(type, device, time);
        this.mastershipInfo = mastershipInfo;
    }

    public MastershipInfo mastershipInfo() {
        return this.mastershipInfo;
    }

    @Deprecated
    public RoleInfo roleInfo() {
        return new RoleInfo(this.mastershipInfo.master().orElse(null), this.mastershipInfo.backups());
    }

    public int hashCode() {
        return Objects.hash(this.type(), this.subject(), this.mastershipInfo(), this.time());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MastershipEvent) {
            MastershipEvent other = (MastershipEvent)obj;
            return Objects.equals(this.type(), other.type()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.mastershipInfo(), other.mastershipInfo()) && Objects.equals(this.time(), other.time());
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("time", (Object)Tools.defaultOffsetDataTime((long)this.time())).add("type", this.type()).add("subject", this.subject()).add("mastershipInfo", (Object)this.mastershipInfo()).toString();
    }

    public static enum Type {
        MASTER_CHANGED,
        BACKUPS_CHANGED,
        SUSPENDED;

    }
}

