/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.onosproject.store.primitives.TransactionId;

public class TransactionLog<T> {
    private final TransactionId transactionId;
    private final long version;
    private final List<T> records;

    public TransactionLog(TransactionId transactionId, long version, List<T> records) {
        this.transactionId = transactionId;
        this.version = version;
        this.records = ImmutableList.copyOf(records);
    }

    public TransactionId transactionId() {
        return this.transactionId;
    }

    public long version() {
        return this.version;
    }

    public List<T> records() {
        return this.records;
    }

    public boolean equals(Object object) {
        if (object instanceof TransactionLog) {
            TransactionLog that = (TransactionLog)object;
            return this.transactionId.equals((Object)that.transactionId) && this.records.equals(that.records);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transactionId, this.records});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("transactionId", (Object)this.transactionId).add("version", this.version).add("records", this.records).toString();
    }

    public <U> TransactionLog<U> map(Function<T, U> mapper) {
        return new TransactionLog<T>(this.transactionId, this.version, Lists.transform(this.records, mapper::apply));
    }
}

