/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.Beta;
import java.io.InputStream;
import java.net.URI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.net.config.InvalidFieldException;
import org.onosproject.net.config.basics.HostLearningConfig;

@Beta
public class HostLearningConfigTest {
    private ConnectPoint cp;
    private HostLearningConfig config;
    private HostLearningConfig invalidConfig;

    @Before
    public void setUp() throws Exception {
        InputStream jsonStream = HostLearningConfigTest.class.getResourceAsStream("/host-learning-config.json");
        InputStream invalidJsonStream = HostLearningConfigTest.class.getResourceAsStream("/host-learning-config-invalid.json");
        ConnectPoint subject = this.cp = new ConnectPoint((ElementId)DeviceId.deviceId((URI)new URI("of:0000000000000202")), PortNumber.portNumber((long)5L));
        String key = "org.onosproject.core";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(jsonStream);
        JsonNode invalidJsonNode = mapper.readTree(invalidJsonStream);
        MockDelegate delegate = new MockDelegate();
        this.config = new HostLearningConfig();
        this.config.init((Object)subject, key, jsonNode, mapper, (ConfigApplyDelegate)delegate);
        this.invalidConfig = new HostLearningConfig();
        this.invalidConfig.init((Object)subject, key, invalidJsonNode, mapper, (ConfigApplyDelegate)delegate);
    }

    @Test(expected=InvalidFieldException.class)
    public void isValid() {
        Assert.assertTrue((boolean)this.config.isValid());
        Assert.assertFalse((boolean)this.invalidConfig.isValid());
    }

    @Test
    public void testEnableLearning() {
        this.config.setEnabled("false");
        Assert.assertTrue((this.config.hostLearningEnabled() == false ? 1 : 0) != 0);
        this.config.setEnabled("true");
        Assert.assertTrue((boolean)this.config.hostLearningEnabled());
    }

    private class MockDelegate
    implements ConfigApplyDelegate {
        private MockDelegate() {
        }

        public void onApply(Config config) {
        }
    }
}

