/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.host;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.event.AbstractEventTest;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.PortNumber;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.provider.ProviderId;

public class HostEventTest
extends AbstractEventTest {
    private Host createHost() {
        MacAddress mac = MacAddress.valueOf((String)"00:00:11:00:00:01");
        VlanId vlan = VlanId.vlanId((short)10);
        HostLocation loc = new HostLocation(DeviceId.deviceId((String)"of:foo"), PortNumber.portNumber((long)100L), 123L);
        HashSet ipset = Sets.newHashSet((Object[])new IpAddress[]{IpAddress.valueOf((String)"10.0.0.1"), IpAddress.valueOf((String)"10.0.0.2")});
        HostId hid = HostId.hostId((MacAddress)mac, (VlanId)vlan);
        return new DefaultHost(new ProviderId("of", "foo"), hid, mac, vlan, loc, (Set)ipset, new Annotations[0]);
    }

    @Override
    @Test
    public void withTime() {
        Host host = this.createHost();
        HostEvent event = new HostEvent(HostEvent.Type.HOST_ADDED, host, 123L);
        HostEventTest.validateEvent(event, HostEvent.Type.HOST_ADDED, host, 123L);
    }

    @Override
    @Test
    public void withoutTime() {
        Host host = this.createHost();
        long before = System.currentTimeMillis();
        HostEvent event = new HostEvent(HostEvent.Type.HOST_ADDED, host, before);
        long after = System.currentTimeMillis();
        HostEventTest.validateEvent(event, HostEvent.Type.HOST_ADDED, host, before, after);
    }
}

