/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.SetEvent;

public class SetEventTest {
    SetEvent<String> event1 = new SetEvent("map1", SetEvent.Type.ADD, (Object)"e1");
    SetEvent<String> event2 = new SetEvent("map1", SetEvent.Type.REMOVE, (Object)"e1");
    SetEvent<String> sameAsEvent2 = new SetEvent("map1", SetEvent.Type.REMOVE, (Object)"e1");
    SetEvent<String> event3 = new SetEvent("map1", SetEvent.Type.ADD, (Object)"e2");
    SetEvent<String> event4 = new SetEvent("map1", SetEvent.Type.REMOVE, (Object)"e2");

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(EventuallyConsistentMapEvent.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.event1}).addEqualityGroup(new Object[]{this.event2, this.sameAsEvent2}).addEqualityGroup(new Object[]{this.event3}).addEqualityGroup(new Object[]{this.event4}).testEquals();
    }

    @Test
    public void testConstruction() {
        MatcherAssert.assertThat((Object)this.event1.type(), (Matcher)Matchers.is((Object)SetEvent.Type.ADD));
        MatcherAssert.assertThat((Object)this.event1.entry(), (Matcher)Matchers.is((Object)"e1"));
        MatcherAssert.assertThat((Object)this.event1.name(), (Matcher)Matchers.is((Object)"map1"));
    }
}

