/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.ResourceGroup;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;

@Immutable
@Beta
public final class ProtectedTransportIntent
extends ConnectivityIntent {
    private final DeviceId one;
    private final DeviceId two;

    private ProtectedTransportIntent(DeviceId one, DeviceId two, ApplicationId appId, Key key, Collection<NetworkResource> resources, TrafficSelector selector, TrafficTreatment treatment, List<Constraint> constraints, int priority, ResourceGroup resourceGroup) {
        super(appId, key, resources, selector, treatment, constraints, priority, resourceGroup);
        this.one = (DeviceId)Preconditions.checkNotNull((Object)one, (Object)"one cannot be null");
        this.two = (DeviceId)Preconditions.checkNotNull((Object)two, (Object)"two cannot be null");
    }

    public DeviceId one() {
        return this.one;
    }

    public DeviceId two() {
        return this.two;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("key", (Object)this.key()).add("appId", (Object)this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("selector", (Object)this.selector()).add("treatment", (Object)this.treatment()).add("one", (Object)this.one()).add("two", (Object)this.two()).add("constraints", this.constraints()).add("resourceGroup", (Object)this.resourceGroup()).toString();
    }

    private ProtectedTransportIntent() {
        this.one = null;
        this.two = null;
    }

    public static final class Builder
    extends ConnectivityIntent.Builder {
        private DeviceId one;
        private DeviceId two;

        private Builder() {
            this.resources = ImmutableList.of();
        }

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder selector(TrafficSelector selector) {
            return (Builder)super.selector(selector);
        }

        @Override
        public Builder treatment(TrafficTreatment treatment) {
            return (Builder)super.treatment(treatment);
        }

        @Override
        public Builder constraints(List<Constraint> constraints) {
            return (Builder)super.constraints(constraints);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        @Override
        public Builder resourceGroup(ResourceGroup resourceGroup) {
            return (Builder)super.resourceGroup(resourceGroup);
        }

        public Builder one(DeviceId one) {
            this.one = (DeviceId)Preconditions.checkNotNull((Object)one);
            return this;
        }

        public Builder two(DeviceId two) {
            this.two = (DeviceId)Preconditions.checkNotNull((Object)two);
            return this;
        }

        public ProtectedTransportIntent build() {
            return new ProtectedTransportIntent(this.one, this.two, this.appId, this.key, this.resources, this.selector, this.treatment, this.constraints, this.priority, this.resourceGroup);
        }
    }
}

