/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.onosproject.ui.topo.DeviceHighlight;
import org.onosproject.ui.topo.HostHighlight;
import org.onosproject.ui.topo.LinkHighlight;
import org.onosproject.ui.topo.NodeHighlight;

public class Highlights {
    private static final String EMPTY = "";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private final Map<String, DeviceHighlight> devices = new HashMap<String, DeviceHighlight>();
    private final Map<String, HostHighlight> hosts = new HashMap<String, HostHighlight>();
    private final Map<String, LinkHighlight> links = new HashMap<String, LinkHighlight>();
    private Amount subdueLevel = Amount.ZERO;
    private int delayMs = 0;

    public Highlights delay(int ms) {
        Preconditions.checkArgument((ms >= 0 ? 1 : 0) != 0, (Object)"Delay cannot be lower than 0");
        this.delayMs = ms;
        return this;
    }

    public int delayMs() {
        return this.delayMs;
    }

    public Highlights add(DeviceHighlight dh) {
        this.devices.put(dh.elementId(), dh);
        return this;
    }

    public Highlights add(HostHighlight hh) {
        this.hosts.put(hh.elementId(), hh);
        return this;
    }

    public Highlights add(LinkHighlight lh) {
        this.links.put(lh.elementId(), lh);
        return this;
    }

    public Highlights subdueAllElse(Amount amount) {
        this.subdueLevel = (Amount)((Object)Preconditions.checkNotNull((Object)((Object)amount)));
        return this;
    }

    public Collection<DeviceHighlight> devices() {
        return Collections.unmodifiableCollection(this.devices.values());
    }

    public Collection<HostHighlight> hosts() {
        return Collections.unmodifiableCollection(this.hosts.values());
    }

    public Collection<LinkHighlight> links() {
        return Collections.unmodifiableCollection(this.links.values());
    }

    public Amount subdueLevel() {
        return this.subdueLevel;
    }

    public NodeHighlight getNode(String id) {
        NodeHighlight nh = this.devices.get(id);
        return nh != null ? nh : (NodeHighlight)this.hosts.get(id);
    }

    public DeviceHighlight getDevice(String id) {
        return this.devices.get(id);
    }

    public HostHighlight getHost(String id) {
        return this.hosts.get(id);
    }

    public LinkHighlight getLink(String id) {
        return this.links.get(id);
    }

    public static enum Amount {
        ZERO(""),
        MINIMALLY("min"),
        MAXIMALLY("max");

        private final String s;

        private Amount(String str) {
            this.s = str;
        }

        public String toString() {
            return this.s;
        }
    }
}

