/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.VlanId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.ResourceId;
import org.onosproject.net.resource.Resources;

public class DiscreteResourceIdTest {
    private static final DeviceId D1 = DeviceId.deviceId((String)"of:001");
    private static final DeviceId D2 = DeviceId.deviceId((String)"of:002");
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final VlanId VLAN1 = VlanId.vlanId((short)100);

    @Test
    public void testEquality() {
        DiscreteResourceId id1 = Resources.discrete((DeviceId)D1, (PortNumber)P1, (Object[])new Object[]{VLAN1}).id();
        DiscreteResourceId sameAsId1 = Resources.discrete((DeviceId)D1, (PortNumber)P1, (Object[])new Object[]{VLAN1}).id();
        DiscreteResourceId id2 = Resources.discrete((DeviceId)D2, (PortNumber)P1, (Object[])new Object[]{VLAN1}).id();
        new EqualsTester().addEqualityGroup(new Object[]{id1, sameAsId1}).addEqualityGroup(new Object[]{id2});
    }

    @Test
    public void testSimpleTypeName() {
        DiscreteResourceId id = Resources.discrete((DeviceId)D1, (PortNumber)P1, (Object[])new Object[]{VLAN1}).id();
        Assert.assertThat((Object)id.simpleTypeName(), (Matcher)Matchers.is((Object)"VlanId"));
    }

    @Test
    public void testSimpleTypeNameOfRoot() {
        Assert.assertThat((Object)ResourceId.ROOT.simpleTypeName(), (Matcher)Matchers.is((Object)"Root"));
    }
}

