/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.Partition;
import org.onosproject.cluster.PartitionId;
import org.onosproject.core.Version;

public class DefaultPartition
implements Partition {
    private final PartitionId id;
    private final Version version;
    private final Collection<NodeId> members;

    protected DefaultPartition() {
        this.id = null;
        this.version = null;
        this.members = null;
    }

    public DefaultPartition(PartitionId id, Version version, Collection<NodeId> members) {
        this.id = (PartitionId)Preconditions.checkNotNull((Object)id);
        this.version = version;
        this.members = ImmutableSet.copyOf(members);
    }

    public DefaultPartition(Partition other) {
        this.id = (PartitionId)Preconditions.checkNotNull((Object)other.getId());
        this.version = (Version)Preconditions.checkNotNull((Object)other.getVersion());
        this.members = ImmutableSet.copyOf(other.getMembers());
    }

    @Override
    public PartitionId getId() {
        return this.id;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public Collection<NodeId> getMembers() {
        return this.members;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id).add("version", (Object)this.version).add("members", this.members).toString();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.members);
    }

    public boolean equals(Object other) {
        if (!(other instanceof DefaultPartition)) {
            return false;
        }
        DefaultPartition that = (DefaultPartition)other;
        return this.getId().equals(that.getId()) && Sets.symmetricDifference((Set)Sets.newHashSet(this.members), (Set)Sets.newHashSet(that.members)).isEmpty();
    }
}

