/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Objects;
import org.onosproject.net.ElementId;

public final class DeviceId
extends ElementId {
    public static final DeviceId NONE = DeviceId.deviceId("none:none");
    private static final int DEVICE_ID_MAX_LENGTH = 1024;
    private final URI uri;
    private final String str;

    private DeviceId(URI uri) {
        this.uri = uri;
        this.str = uri.toString().toLowerCase();
    }

    protected DeviceId() {
        this.uri = null;
        this.str = null;
    }

    public static DeviceId deviceId(URI uri) {
        return new DeviceId(uri);
    }

    public static DeviceId deviceId(String string) {
        Preconditions.checkArgument((string.length() <= 1024 ? 1 : 0) != 0, (Object)"deviceId exceeds maximum length 1024");
        return DeviceId.deviceId(URI.create(string));
    }

    public URI uri() {
        return this.uri;
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DeviceId) {
            DeviceId that = (DeviceId)obj;
            return this.getClass() == that.getClass() && Objects.equals(this.str, that.str);
        }
        return false;
    }

    public String toString() {
        return this.str;
    }
}

