/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import java.util.Optional;
import org.onosproject.net.AbstractDescription;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.behaviour.PatchDescription;

public final class DefaultPatchDescription
extends AbstractDescription
implements PatchDescription {
    private final Optional<String> deviceId;
    private final String ifaceName;
    private final String peerName;

    private DefaultPatchDescription(Optional<String> deviceId, String ifaceName, String peerName, SparseAnnotations ... annotations) {
        super(annotations);
        this.deviceId = deviceId;
        this.ifaceName = ifaceName;
        this.peerName = peerName;
    }

    @Override
    public Optional<String> deviceId() {
        return this.deviceId;
    }

    @Override
    public String ifaceName() {
        return this.ifaceName;
    }

    @Override
    public String peer() {
        return this.peerName;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.deviceId, this.ifaceName, this.peerName);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultPatchDescription) {
            DefaultPatchDescription that = (DefaultPatchDescription)obj;
            return this.getClass() == that.getClass() && Objects.equals(this.deviceId, that.deviceId) && Objects.equals(this.ifaceName, that.ifaceName) && Objects.equals(this.peerName, that.peerName);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("deviceId", this.deviceId).add("ifaceName", (Object)this.ifaceName).add("peerName", (Object)this.peerName).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements PatchDescription.Builder {
        private Optional<String> deviceId = Optional.empty();
        private String ifaceName;
        private String peerName;

        private Builder() {
        }

        @Override
        public PatchDescription build() {
            return new DefaultPatchDescription((Optional)this.deviceId, this.ifaceName, this.peerName, new SparseAnnotations[0]);
        }

        @Override
        public PatchDescription.Builder deviceId(String deviceId) {
            this.deviceId = Optional.ofNullable(deviceId);
            return this;
        }

        @Override
        public PatchDescription.Builder ifaceName(String ifaceName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)ifaceName) ? 1 : 0) != 0);
            this.ifaceName = ifaceName;
            return this;
        }

        @Override
        public PatchDescription.Builder peer(String peerName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)peerName) ? 1 : 0) != 0);
            this.peerName = peerName;
            return this;
        }
    }
}

