/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.protection;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;
import org.onosproject.net.FilteredConnectPoint;

@Beta
@Immutable
public class TransportEndpointDescription {
    private final FilteredConnectPoint output;
    private final boolean enabled;

    protected TransportEndpointDescription(FilteredConnectPoint output, boolean enabled) {
        this.output = (FilteredConnectPoint)Preconditions.checkNotNull((Object)output);
        this.enabled = enabled;
    }

    public FilteredConnectPoint output() {
        return this.output;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("output", (Object)this.output).add("enabled", this.enabled).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private FilteredConnectPoint output;
        private boolean enabled = true;

        public Builder copyFrom(TransportEndpointDescription src) {
            this.output = src.output();
            this.enabled = src.isEnabled();
            return this;
        }

        public Builder withOutput(FilteredConnectPoint output) {
            this.output = output;
            return this;
        }

        public Builder withEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public TransportEndpointDescription build() {
            Preconditions.checkNotNull((Object)this.output, (Object)"output field is mandatory");
            return new TransportEndpointDescription(this.output, this.enabled);
        }
    }
}

