/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config;

public class InvalidConfigException
extends RuntimeException {
    private final String subjectKey;
    private final String subject;
    private final String configKey;

    public InvalidConfigException(String subjectKey, String subject, String configKey) {
        this(subjectKey, subject, configKey, null);
    }

    public InvalidConfigException(String subjectKey, String subject, String configKey, Throwable cause) {
        super(InvalidConfigException.message(subjectKey, subject, configKey, cause), cause);
        this.subjectKey = subjectKey;
        this.subject = subject;
        this.configKey = configKey;
    }

    public String subjectKey() {
        return this.subjectKey;
    }

    public String subject() {
        return this.subject;
    }

    public String configKey() {
        return this.configKey;
    }

    private static String message(String subjectKey, String subject, String configKey, Throwable cause) {
        String error = "Error parsing config " + subjectKey + "/" + subject + "/" + configKey;
        if (cause != null) {
            error = error + ": " + cause.getMessage();
        }
        return error;
    }
}

