/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import java.util.Objects;
import org.onlab.packet.MacAddress;
import org.onosproject.net.flow.criteria.Criterion;

public final class EthCriterion
implements Criterion {
    private final MacAddress mac;
    private final MacAddress mask;
    private final Criterion.Type type;

    EthCriterion(MacAddress mac, MacAddress mask, Criterion.Type type) {
        this.mac = mac;
        this.mask = mask;
        this.type = type;
    }

    EthCriterion(MacAddress mac, Criterion.Type type) {
        this(mac, null, type);
    }

    @Override
    public Criterion.Type type() {
        return this.type;
    }

    public MacAddress mac() {
        return this.mac;
    }

    public MacAddress mask() {
        return this.mask;
    }

    public String toString() {
        return this.mask != null ? this.type().toString() + ":" + this.mac + "/" + this.mask : this.type().toString() + ":" + this.mac;
    }

    public int hashCode() {
        return Objects.hash(this.type.ordinal(), this.mac, this.mask);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EthCriterion) {
            EthCriterion that = (EthCriterion)obj;
            return Objects.equals(this.mac, that.mac) && Objects.equals(this.mask, that.mask) && Objects.equals((Object)this.type, (Object)that.type);
        }
        return false;
    }
}

