/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import java.util.Objects;
import org.onosproject.net.flow.criteria.Criterion;

public final class MplsTcCriterion
implements Criterion {
    private static final byte MASK = 7;
    private final byte mplsTc;

    MplsTcCriterion(byte mplsTc) {
        this.mplsTc = (byte)(mplsTc & 7);
    }

    @Override
    public Criterion.Type type() {
        return Criterion.Type.MPLS_TC;
    }

    public byte tc() {
        return this.mplsTc;
    }

    public String toString() {
        return this.type().toString() + ":" + Long.toHexString(this.mplsTc);
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.mplsTc);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MplsTcCriterion) {
            MplsTcCriterion that = (MplsTcCriterion)obj;
            return Objects.equals(this.mplsTc, that.mplsTc) && Objects.equals((Object)this.type(), (Object)that.type());
        }
        return false;
    }
}

