/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import java.util.Objects;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntentUtils {
    private static final Logger log = LoggerFactory.getLogger(IntentUtils.class);

    private IntentUtils() {
    }

    public static boolean intentsAreEqual(Intent one, Intent two) {
        if (one.getClass() != two.getClass()) {
            return false;
        }
        if (!Objects.equals(one.appId(), two.appId()) || !Objects.equals(one.key(), two.key())) {
            return false;
        }
        if (one instanceof SinglePointToMultiPointIntent) {
            SinglePointToMultiPointIntent intent1 = (SinglePointToMultiPointIntent)one;
            SinglePointToMultiPointIntent intent2 = (SinglePointToMultiPointIntent)two;
            return Objects.equals(intent1.selector(), intent2.selector()) && Objects.equals(intent1.treatment(), intent2.treatment()) && Objects.equals(intent1.filteredIngressPoint(), intent2.filteredIngressPoint()) && Objects.equals(intent1.filteredEgressPoints(), intent2.filteredEgressPoints()) && Objects.equals(intent1.constraints(), intent2.constraints());
        }
        if (one instanceof MultiPointToSinglePointIntent) {
            MultiPointToSinglePointIntent intent1 = (MultiPointToSinglePointIntent)one;
            MultiPointToSinglePointIntent intent2 = (MultiPointToSinglePointIntent)two;
            return Objects.equals(intent1.selector(), intent2.selector()) && Objects.equals(intent1.filteredIngressPoints(), intent2.filteredIngressPoints()) && Objects.equals(intent1.filteredEgressPoint(), intent2.filteredEgressPoint()) && Objects.equals(intent1.treatment(), intent2.treatment()) && Objects.equals(intent1.constraints(), intent2.constraints());
        }
        if (one instanceof PointToPointIntent) {
            PointToPointIntent intent1 = (PointToPointIntent)one;
            PointToPointIntent intent2 = (PointToPointIntent)two;
            return Objects.equals(intent1.selector(), intent2.selector()) && Objects.equals(intent1.treatment(), intent2.treatment()) && Objects.equals(intent1.constraints(), intent2.constraints()) && Objects.equals(intent1.filteredIngressPoint().connectPoint(), intent2.filteredIngressPoint().connectPoint()) && Objects.equals(intent1.filteredEgressPoint().connectPoint(), intent2.filteredEgressPoint().connectPoint());
        }
        log.error("Unimplemented intent type");
        return false;
    }
}

