/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.pi.runtime.PiAction;
import org.onosproject.net.pi.runtime.PiActionGroupMemberId;
import org.onosproject.net.pi.runtime.PiEntity;
import org.onosproject.net.pi.runtime.PiEntityType;

@Beta
public final class PiActionGroupMember
implements PiEntity {
    private final PiActionGroupMemberId id;
    private final PiAction action;
    private final int weight;

    private PiActionGroupMember(PiActionGroupMemberId id, PiAction action, int weight) {
        this.id = id;
        this.action = action;
        this.weight = weight;
    }

    public PiActionGroupMemberId id() {
        return this.id;
    }

    public PiAction action() {
        return this.action;
    }

    public int weight() {
        return this.weight;
    }

    @Override
    public PiEntityType piEntityType() {
        return PiEntityType.GROUP_MEMBER;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PiActionGroupMember)) {
            return false;
        }
        PiActionGroupMember that = (PiActionGroupMember)o;
        return this.weight == that.weight && Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.action, (Object)that.action);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.action, this.weight});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("action", (Object)this.action).add("weight", this.weight).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PiActionGroupMemberId id;
        private PiAction action;
        private int weight;

        private Builder() {
        }

        public Builder withId(PiActionGroupMemberId id) {
            this.id = id;
            return this;
        }

        public Builder withAction(PiAction action) {
            this.action = action;
            return this;
        }

        public Builder withWeight(int weight) {
            this.weight = weight;
            return this;
        }

        public PiActionGroupMember build() {
            Preconditions.checkNotNull((Object)this.id);
            Preconditions.checkNotNull((Object)this.action);
            return new PiActionGroupMember(this.id, this.action, this.weight);
        }
    }
}

