/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.onosproject.store.service.AsyncAtomicValue;
import org.onosproject.store.service.AtomicValue;
import org.onosproject.store.service.AtomicValueEventListener;
import org.onosproject.store.service.StorageException;
import org.onosproject.store.service.Synchronous;

public class DefaultAtomicValue<V>
extends Synchronous<AsyncAtomicValue<V>>
implements AtomicValue<V> {
    private final AsyncAtomicValue<V> asyncValue;
    private final long operationTimeoutMillis;

    public DefaultAtomicValue(AsyncAtomicValue<V> asyncValue, long operationTimeoutMillis) {
        super(asyncValue);
        this.asyncValue = asyncValue;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public boolean compareAndSet(V expect, V update) {
        return this.complete(this.asyncValue.compareAndSet(expect, update));
    }

    @Override
    public V get() {
        return this.complete(this.asyncValue.get());
    }

    @Override
    public V getAndSet(V value) {
        return this.complete(this.asyncValue.getAndSet(value));
    }

    @Override
    public void set(V value) {
        this.complete(this.asyncValue.set(value));
    }

    @Override
    public void addListener(AtomicValueEventListener<V> listener) {
        this.complete(this.asyncValue.addListener(listener));
    }

    @Override
    public void removeListener(AtomicValueEventListener<V> listener) {
        this.complete(this.asyncValue.removeListener(listener));
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StorageException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new StorageException.Timeout();
        }
        catch (ExecutionException e) {
            throw new StorageException(e.getCause());
        }
    }
}

