/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.onosproject.store.service.AsyncDistributedLock;
import org.onosproject.store.service.DistributedLock;
import org.onosproject.store.service.StorageException;
import org.onosproject.store.service.Synchronous;
import org.onosproject.store.service.Version;

public class DefaultDistributedLock
extends Synchronous<AsyncDistributedLock>
implements DistributedLock {
    private final AsyncDistributedLock asyncLock;
    private final long operationTimeoutMillis;

    public DefaultDistributedLock(AsyncDistributedLock asyncLock, long operationTimeoutMillis) {
        super(asyncLock);
        this.asyncLock = asyncLock;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public Version lock() {
        return this.complete(this.asyncLock.lock());
    }

    @Override
    public Optional<Version> tryLock() {
        return this.complete(this.asyncLock.tryLock());
    }

    @Override
    public Optional<Version> tryLock(Duration timeout) {
        return this.complete(this.asyncLock.tryLock(timeout));
    }

    @Override
    public void unlock() {
        this.complete(this.asyncLock.unlock());
    }

    private <T> T complete(CompletableFuture<T> future) {
        if (this.operationTimeoutMillis == -1L) {
            return future.join();
        }
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StorageException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new StorageException.Timeout();
        }
        catch (ExecutionException e) {
            throw new StorageException(e.getCause());
        }
    }
}

