/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import com.google.common.base.Preconditions;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.Version;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.RevisionType;
import org.onosproject.store.service.Serializer;

public abstract class DistributedPrimitiveOptions<O extends DistributedPrimitiveOptions<O>> {
    private final DistributedPrimitive.Type type;
    private String name;
    private ApplicationId applicationId;
    private Serializer serializer;
    private boolean partitionsDisabled = false;
    private boolean meteringDisabled = false;
    private boolean readOnly = false;
    private boolean relaxedReadConsistency = false;
    private Version version;
    private RevisionType revisionType;

    public DistributedPrimitiveOptions(DistributedPrimitive.Type type) {
        this.type = type;
    }

    public O withName(String name) {
        this.name = name;
        return (O)this;
    }

    public O withSerializer(Serializer serializer) {
        this.serializer = serializer;
        return (O)this;
    }

    public O withApplicationId(ApplicationId applicationId) {
        this.applicationId = applicationId;
        return (O)this;
    }

    public O withVersion(Version version) {
        this.version = version;
        return (O)this;
    }

    public O withRevisionType(RevisionType revisionType) {
        this.revisionType = (RevisionType)((Object)Preconditions.checkNotNull((Object)((Object)revisionType)));
        return (O)this;
    }

    @Deprecated
    public O withMeteringDisabled() {
        this.meteringDisabled = true;
        return (O)this;
    }

    public O withUpdatesDisabled() {
        this.readOnly = true;
        return (O)this;
    }

    public O withRelaxedReadConsistency() {
        this.relaxedReadConsistency = true;
        return (O)this;
    }

    public final boolean meteringEnabled() {
        return !this.meteringDisabled;
    }

    public final boolean partitionsDisabled() {
        return this.partitionsDisabled;
    }

    public final boolean readOnly() {
        return this.readOnly;
    }

    public final boolean relaxedReadConsistency() {
        return this.relaxedReadConsistency;
    }

    public final Serializer serializer() {
        return this.serializer;
    }

    public final ApplicationId applicationId() {
        return this.applicationId;
    }

    public final String name() {
        return this.name;
    }

    public final DistributedPrimitive.Type type() {
        return this.type;
    }

    public final Version version() {
        return this.version;
    }

    public RevisionType revisionType() {
        return this.revisionType;
    }
}

