/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class LayoutLocation {
    private static final double ZERO_THRESHOLD = 9.9E-324;
    private static final String COMMA = ",";
    private static final String TILDE = "~";
    private static final String EMPTY = "";
    private static final String E_BAD_COMPACT = "Badly formatted compact form: ";
    private static final String E_EMPTY_ID = "id must be non-empty";
    private static final String E_BAD_DOUBLE = "unparsable double";
    private final String id;
    private final double latOrY;
    private final double longOrX;
    private final Type locType;

    private LayoutLocation(String id, Type locType, double latOrY, double longOrX) {
        this.id = id;
        this.latOrY = latOrY;
        this.longOrX = longOrX;
        this.locType = locType;
    }

    private boolean doubleIsZero(double value) {
        return value >= -9.9E-324 && value <= 9.9E-324;
    }

    public boolean isOrigin() {
        return this.doubleIsZero(this.latOrY) && this.doubleIsZero(this.longOrX);
    }

    public String id() {
        return this.id;
    }

    public Type locType() {
        return this.locType;
    }

    public double latOrY() {
        return this.latOrY;
    }

    public double longOrX() {
        return this.longOrX;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("loc-type", (Object)this.locType).add("lat/Y", this.latOrY).add("long/X", this.longOrX).toString();
    }

    public String toCompactListString() {
        return this.id + COMMA + (Object)((Object)this.locType) + COMMA + this.latOrY + COMMA + this.longOrX;
    }

    public static LayoutLocation fromCompactString(String s) {
        double longOrX;
        double latOrY;
        String[] tokens = s.split(COMMA);
        if (tokens.length != 4) {
            throw new IllegalArgumentException(E_BAD_COMPACT + s);
        }
        String id = tokens[0];
        String type = tokens[1];
        String latY = tokens[2];
        String longX = tokens[3];
        if (Strings.isNullOrEmpty((String)id)) {
            throw new IllegalArgumentException("Badly formatted compact form: id must be non-empty");
        }
        try {
            latOrY = Double.parseDouble(latY);
            longOrX = Double.parseDouble(longX);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Badly formatted compact form: unparsable double");
        }
        return LayoutLocation.layoutLocation(id, type, latOrY, longOrX);
    }

    public static String toCompactListString(LayoutLocation ... locs) {
        if (locs == null || locs.length == 0) {
            return EMPTY;
        }
        List<LayoutLocation> lls = Arrays.asList(locs);
        return LayoutLocation.toCompactListString(lls);
    }

    public static String toCompactListString(List<LayoutLocation> locs) {
        if (locs == null || locs.isEmpty()) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        for (LayoutLocation ll : locs) {
            sb.append(ll.toCompactListString()).append(TILDE);
        }
        int len = sb.length();
        sb.replace(len - 1, len, EMPTY);
        return sb.toString();
    }

    public static List<LayoutLocation> fromCompactListString(String compactList) {
        ArrayList<LayoutLocation> locs = new ArrayList<LayoutLocation>();
        if (!Strings.isNullOrEmpty((String)compactList)) {
            String[] items;
            for (String s : items = compactList.split(TILDE)) {
                locs.add(LayoutLocation.fromCompactString(s));
            }
        }
        return locs;
    }

    public static LayoutLocation layoutLocation(String id, Type locType, double latOrY, double longOrX) {
        Preconditions.checkNotNull((Object)id, (Object)"must supply an identifier");
        Preconditions.checkNotNull((Object)((Object)locType), (Object)"must declare location type");
        return new LayoutLocation(id, locType, latOrY, longOrX);
    }

    public static LayoutLocation layoutLocation(String id, String locType, double latOrY, double longOrX) {
        Type t = Type.valueOf(locType.toUpperCase());
        return new LayoutLocation(id, t, latOrY, longOrX);
    }

    public static enum Type {
        GEO,
        GRID;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

