/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.util.Bandwidth;
import org.onosproject.net.Link;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.net.intent.constraint.LinkTypeConstraint;

public class ConstraintObjectsTest {
    private final Bandwidth bandwidth1 = Bandwidth.bps((double)100.0);
    private final Bandwidth sameAsBandwidth1 = Bandwidth.bps((double)100.0);
    private final Bandwidth bandwidth2 = Bandwidth.bps((double)200.0);
    final BandwidthConstraint bandwidthConstraint1 = new BandwidthConstraint(this.bandwidth1);
    final BandwidthConstraint bandwidthConstraintSameAs1 = new BandwidthConstraint(this.sameAsBandwidth1);
    final BandwidthConstraint bandwidthConstraint2 = new BandwidthConstraint(this.bandwidth2);
    final LinkTypeConstraint linkTypeConstraint1 = new LinkTypeConstraint(true, new Link.Type[]{Link.Type.OPTICAL, Link.Type.TUNNEL});
    final LinkTypeConstraint linkTypeConstraintSameAs1 = new LinkTypeConstraint(true, new Link.Type[]{Link.Type.OPTICAL, Link.Type.TUNNEL});
    final LinkTypeConstraint linkTypeConstraint2 = new LinkTypeConstraint(true, new Link.Type[]{Link.Type.OPTICAL, Link.Type.DIRECT});

    @Test
    public void testBandwidthConstraintCreation() {
        MatcherAssert.assertThat((Object)this.bandwidthConstraint1.bandwidth().bps(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)100.0)));
        MatcherAssert.assertThat((Object)this.bandwidthConstraintSameAs1.bandwidth().bps(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)100.0)));
        MatcherAssert.assertThat((Object)this.bandwidthConstraint2.bandwidth().bps(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)200.0)));
    }

    @Test
    public void testBandwidthConstraintEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.bandwidthConstraint1, this.bandwidthConstraintSameAs1}).addEqualityGroup(new Object[]{this.bandwidthConstraint2}).testEquals();
    }

    @Test
    public void testLinkTypeConstraintCreation() {
        MatcherAssert.assertThat((Object)this.linkTypeConstraint1.isInclusive(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.linkTypeConstraint1.types(), (Matcher)Matchers.contains((Object[])new Link.Type[]{Link.Type.OPTICAL, Link.Type.TUNNEL}));
        MatcherAssert.assertThat((Object)this.linkTypeConstraintSameAs1.isInclusive(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.linkTypeConstraintSameAs1.types(), (Matcher)Matchers.contains((Object[])new Link.Type[]{Link.Type.OPTICAL, Link.Type.TUNNEL}));
        MatcherAssert.assertThat((Object)this.linkTypeConstraint2.isInclusive(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.linkTypeConstraint2.types(), (Matcher)Matchers.contains((Object[])new Link.Type[]{Link.Type.OPTICAL, Link.Type.DIRECT}));
    }

    @Test
    public void testLinkTypeConstraintEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.linkTypeConstraint1, this.linkTypeConstraintSameAs1}).addEqualityGroup(new Object[]{this.linkTypeConstraint2}).testEquals();
    }
}

