/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.annotations.Beta;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onlab.packet.EthType;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.TpPort;
import org.onlab.packet.VlanId;
import org.onosproject.core.GroupId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.StatTriggerField;
import org.onosproject.net.flow.StatTriggerFlag;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.meter.MeterId;
import org.onosproject.net.pi.runtime.PiTableAction;

public interface TrafficTreatment {
    public List<Instruction> deferred();

    public List<Instruction> immediate();

    public List<Instruction> allInstructions();

    public Instructions.TableTypeTransition tableTransition();

    public boolean clearedDeferred();

    public Instructions.MetadataInstruction writeMetadata();

    public Instructions.StatTriggerInstruction statTrigger();

    public Instructions.MeterInstruction metered();

    public Set<Instructions.MeterInstruction> meters();

    public static interface Builder {
        public Builder add(Instruction var1);

        public Builder drop();

        public Builder punt();

        public Builder setOutput(PortNumber var1);

        public Builder setEthSrc(MacAddress var1);

        public Builder setEthDst(MacAddress var1);

        public Builder setVlanId(VlanId var1);

        public Builder setVlanPcp(Byte var1);

        public Builder setIpSrc(IpAddress var1);

        public Builder setIpDst(IpAddress var1);

        public Builder decNwTtl();

        public Builder copyTtlOut();

        public Builder copyTtlIn();

        public Builder pushMpls();

        public Builder popMpls();

        public Builder popMpls(EthType var1);

        public Builder setMpls(MplsLabel var1);

        public Builder setMplsBos(boolean var1);

        public Builder decMplsTtl();

        public Builder group(GroupId var1);

        public Builder setQueue(long var1);

        public Builder setQueue(long var1, PortNumber var3);

        public Builder meter(MeterId var1);

        public Builder transition(Integer var1);

        public Builder popVlan();

        public Builder pushVlan();

        public Builder pushVlan(EthType var1);

        public Builder deferred();

        public Builder immediate();

        public Builder wipeDeferred();

        public Builder notWipeDeferred();

        public Builder writeMetadata(long var1, long var3);

        public Builder setTunnelId(long var1);

        public Builder setTcpSrc(TpPort var1);

        public Builder setTcpDst(TpPort var1);

        public Builder setUdpSrc(TpPort var1);

        public Builder setUdpDst(TpPort var1);

        public Builder setArpSpa(IpAddress var1);

        public Builder setArpSha(MacAddress var1);

        public Builder setArpOp(short var1);

        @Beta
        public Builder piTableAction(PiTableAction var1);

        public Builder extension(ExtensionTreatment var1, DeviceId var2);

        public Builder statTrigger(Map<StatTriggerField, Long> var1, StatTriggerFlag var2);

        public Builder addTreatment(TrafficTreatment var1);

        public TrafficTreatment build();
    }
}

