/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flowobjective;

import com.google.common.annotations.Beta;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flowobjective.FilteringObjQueueKey;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ForwardingObjQueueKey;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjQueueKey;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;

@Beta
public interface FlowObjectiveService {
    public void filter(DeviceId var1, FilteringObjective var2);

    public void forward(DeviceId var1, ForwardingObjective var2);

    public void next(DeviceId var1, NextObjective var2);

    public int allocateNextId();

    public void initPolicy(String var1);

    default public void apply(DeviceId deviceId, Objective objective) {
        if (ForwardingObjective.class.isAssignableFrom(objective.getClass())) {
            this.forward(deviceId, (ForwardingObjective)objective);
        } else if (FilteringObjective.class.isAssignableFrom(objective.getClass())) {
            this.filter(deviceId, (FilteringObjective)objective);
        } else if (NextObjective.class.isAssignableFrom(objective.getClass())) {
            this.next(deviceId, (NextObjective)objective);
        } else {
            throw new UnsupportedOperationException("Unsupported objective of type " + objective.getClass());
        }
    }

    public List<String> getNextMappings();

    public List<String> getPendingFlowObjectives();

    default public ListMultimap<FilteringObjQueueKey, Objective> getFilteringObjQueue() {
        return ArrayListMultimap.create();
    }

    default public ListMultimap<ForwardingObjQueueKey, Objective> getForwardingObjQueue() {
        return ArrayListMultimap.create();
    }

    default public ListMultimap<NextObjQueueKey, Objective> getNextObjQueue() {
        return ArrayListMultimap.create();
    }

    default public Map<FilteringObjQueueKey, Objective> getFilteringObjQueueHead() {
        return Maps.newHashMap();
    }

    default public Map<ForwardingObjQueueKey, Objective> getForwardingObjQueueHead() {
        return Maps.newHashMap();
    }

    default public Map<NextObjQueueKey, Objective> getNextObjQueueHead() {
        return Maps.newHashMap();
    }

    default public void clearQueue() {
        throw new NotImplementedException("clearQueue is not implemented");
    }
}

