/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.collect.ImmutableSet;
import com.google.common.testing.EqualsTester;
import java.util.Collection;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterMetadata;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.DefaultPartition;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.Partition;
import org.onosproject.cluster.PartitionId;
import org.onosproject.core.Version;
import org.onosproject.net.provider.ProviderId;

public class ClusterMetadataTest {
    private final PartitionId pid1 = PartitionId.from((int)1);
    private final PartitionId pid2 = PartitionId.from((int)2);
    private final NodeId nid1 = NodeId.nodeId((String)"10.0.0.1");
    private final NodeId nid2 = NodeId.nodeId((String)"10.0.0.2");
    private final ControllerNode n1 = new DefaultControllerNode(this.nid1, IpAddress.valueOf((String)"10.0.0.1"), 9876);
    private final ControllerNode n2 = new DefaultControllerNode(this.nid2, IpAddress.valueOf((String)"10.0.0.2"), 9876);
    private final Partition p1 = new DefaultPartition(this.pid1, Version.version((String)"1.0.0"), (Collection)ImmutableSet.of((Object)this.nid1));
    private final Partition p2 = new DefaultPartition(this.pid2, Version.version((String)"1.0.0"), (Collection)ImmutableSet.of((Object)this.nid1, (Object)this.nid2));
    private final ClusterMetadata metadata1 = new ClusterMetadata("foo", (Set)ImmutableSet.of((Object)this.n1), (Set)ImmutableSet.of((Object)this.p1));
    private final ClusterMetadata sameAsMetadata1 = new ClusterMetadata("foo", (Set)ImmutableSet.of((Object)this.n1), (Set)ImmutableSet.of((Object)this.p1));
    private final ClusterMetadata metadata2 = new ClusterMetadata("bar", (Set)ImmutableSet.of((Object)this.n1, (Object)this.n2), (Set)ImmutableSet.of((Object)this.p1, (Object)this.p2));
    private final ProviderId defaultProvider = new ProviderId("none", "none");

    @Test
    public void checkEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.metadata1, this.sameAsMetadata1}).addEqualityGroup(new Object[]{this.metadata2}).testEquals();
    }

    @Test
    public void checkConstruction() {
        Assert.assertThat((Object)this.metadata2.getName(), (Matcher)Matchers.is((Object)"bar"));
        Assert.assertThat((Object)this.metadata2.getNodes(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)this.metadata2.getNodes(), (Matcher)Matchers.contains((Object[])new ControllerNode[]{this.n1, this.n2}));
        Assert.assertThat((Object)this.metadata2.getPartitions(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)this.metadata2.getPartitions(), (Matcher)Matchers.contains((Object[])new Partition[]{this.p1, this.p2}));
        Assert.assertThat((Object)this.metadata1.providerId(), (Matcher)Matchers.is((Object)this.defaultProvider));
    }
}

