/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.DeviceId;
import org.onosproject.net.pi.model.PiControlMetadataId;
import org.onosproject.net.pi.model.PiPacketOperationType;
import org.onosproject.net.pi.runtime.PiControlMetadata;
import org.onosproject.net.pi.runtime.PiPacketOperation;

public class PiPacketOperationTest {
    private final DeviceId deviceId = DeviceId.deviceId((String)"dummy");
    private final PiPacketOperation piPacketOperation1 = PiPacketOperation.builder().forDevice(this.deviceId).withData(ImmutableByteSequence.ofOnes((int)512)).withType(PiPacketOperationType.PACKET_OUT).withMetadata(PiControlMetadata.builder().withId(PiControlMetadataId.of((String)"egress_port")).withValue(ImmutableByteSequence.copyFrom((short)255)).build()).build();
    private final PiPacketOperation sameAsPiPacketOperation1 = PiPacketOperation.builder().forDevice(this.deviceId).withData(ImmutableByteSequence.ofOnes((int)512)).withType(PiPacketOperationType.PACKET_OUT).withMetadata(PiControlMetadata.builder().withId(PiControlMetadataId.of((String)"egress_port")).withValue(ImmutableByteSequence.copyFrom((short)255)).build()).build();
    private final PiPacketOperation piPacketOperation2 = PiPacketOperation.builder().forDevice(this.deviceId).withData(ImmutableByteSequence.ofOnes((int)512)).withType(PiPacketOperationType.PACKET_OUT).withMetadata(PiControlMetadata.builder().withId(PiControlMetadataId.of((String)"egress_port")).withValue(ImmutableByteSequence.copyFrom((short)200)).build()).build();

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiPacketOperation.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piPacketOperation1, this.sameAsPiPacketOperation1}).addEqualityGroup(new Object[]{this.piPacketOperation2}).testEquals();
    }

    @Test
    public void testMethods() {
        PiPacketOperation piPacketOperation = PiPacketOperation.builder().forDevice(this.deviceId).withData(ImmutableByteSequence.ofOnes((int)512)).withType(PiPacketOperationType.PACKET_OUT).withMetadata(PiControlMetadata.builder().withId(PiControlMetadataId.of((String)"egress_port")).withValue(ImmutableByteSequence.copyFrom((short)10)).build()).build();
        MatcherAssert.assertThat((Object)piPacketOperation, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)piPacketOperation.deviceId(), (Matcher)Matchers.is((Object)this.deviceId));
        MatcherAssert.assertThat((Object)piPacketOperation.type(), (Matcher)Matchers.is((Object)PiPacketOperationType.PACKET_OUT));
        MatcherAssert.assertThat((Object)piPacketOperation.data(), (Matcher)Matchers.is((Object)ImmutableByteSequence.ofOnes((int)512)));
        MatcherAssert.assertThat((String)"Incorrect metadatas value", (boolean)CollectionUtils.isEqualCollection((Collection)piPacketOperation.metadatas(), (Collection)ImmutableList.of((Object)PiControlMetadata.builder().withId(PiControlMetadataId.of((String)"egress_port")).withValue(ImmutableByteSequence.copyFrom((short)10)).build())));
    }
}

