/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config;

import com.google.common.base.MoreObjects;
import java.util.Optional;
import org.onlab.util.Tools;
import org.onosproject.event.AbstractEvent;
import org.onosproject.net.config.Config;

public class NetworkConfigEvent
extends AbstractEvent<Type, Object> {
    private final Class configClass;
    private final Config config;
    private final Config prevConfig;

    public NetworkConfigEvent(Type type, Object subject, Class configClass) {
        super(type, subject);
        this.configClass = configClass;
        this.config = null;
        this.prevConfig = null;
    }

    public NetworkConfigEvent(Type type, Object subject, Class configClass, long time) {
        super(type, subject, time);
        this.configClass = configClass;
        this.config = null;
        this.prevConfig = null;
    }

    public NetworkConfigEvent(Type type, Object subject, Config config, Config prevConfig, Class configClass) {
        super(type, subject);
        this.configClass = configClass;
        this.config = config;
        this.prevConfig = prevConfig;
    }

    public Class configClass() {
        return this.configClass;
    }

    public Optional<Config> config() {
        return this.config != null ? Optional.of(this.config) : Optional.empty();
    }

    public Optional<Config> prevConfig() {
        return this.prevConfig != null ? Optional.of(this.prevConfig) : Optional.empty();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("time", (Object)Tools.defaultOffsetDataTime((long)this.time())).add("type", this.type()).add("config", this.config()).add("prevConfig", this.prevConfig()).add("configClass", (Object)this.configClass()).toString();
    }

    public static enum Type {
        CONFIG_REGISTERED,
        CONFIG_UNREGISTERED,
        CONFIG_ADDED,
        CONFIG_UPDATED,
        CONFIG_REMOVED;

    }
}

