/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.onosproject.net.DeviceId;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.behaviour.BridgeDescription;
import org.onosproject.net.behaviour.ControlProtocolVersion;
import org.onosproject.net.behaviour.ControllerInfo;

public final class DefaultBridgeDescription
implements BridgeDescription {
    private final String name;
    private final List<ControllerInfo> controllers;
    private final boolean enableLocalController;
    private final Optional<BridgeDescription.FailMode> failMode;
    private final Optional<String> datapathId;
    private final Optional<String> datapathType;
    private final Optional<List<ControlProtocolVersion>> controlProtocols;
    private final Optional<Boolean> disableInBand;

    private DefaultBridgeDescription(String name, List<ControllerInfo> controllers, boolean enableLocalController, Optional<BridgeDescription.FailMode> failMode, Optional<String> datapathId, Optional<String> datapathType, Optional<Boolean> disableInBand, Optional<List<ControlProtocolVersion>> controlProtocols) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.controllers = controllers;
        this.enableLocalController = enableLocalController;
        this.failMode = failMode;
        this.datapathId = datapathId;
        this.datapathType = datapathType;
        this.disableInBand = disableInBand;
        this.controlProtocols = controlProtocols;
    }

    @Override
    public SparseAnnotations annotations() {
        return null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<ControllerInfo> controllers() {
        return this.controllers;
    }

    @Override
    public boolean enableLocalController() {
        return this.enableLocalController;
    }

    @Override
    public Optional<BridgeDescription.FailMode> failMode() {
        return this.failMode;
    }

    @Override
    public Optional<String> datapathId() {
        return this.datapathId;
    }

    @Override
    public Optional<String> datapathType() {
        return this.datapathType;
    }

    @Override
    public Optional<List<ControlProtocolVersion>> controlProtocols() {
        return this.controlProtocols;
    }

    @Override
    public Optional<DeviceId> deviceId() {
        if (this.datapathId.isPresent()) {
            return Optional.of(DeviceId.deviceId("of:" + this.datapathId.get()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Boolean> disableInBand() {
        return this.disableInBand;
    }

    public static BridgeDescription.Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements BridgeDescription.Builder {
        private String name;
        private List<ControllerInfo> controllers = Lists.newArrayList();
        private boolean enableLocalController = false;
        private Optional<BridgeDescription.FailMode> failMode = Optional.empty();
        private Optional<String> datapathId = Optional.empty();
        private Optional<String> datapathType = Optional.empty();
        private Optional<List<ControlProtocolVersion>> controlProtocols = Optional.empty();
        private Optional<Boolean> disableInBand = Optional.empty();

        private Builder() {
        }

        @Override
        public BridgeDescription build() {
            return new DefaultBridgeDescription(this.name, this.controllers, this.enableLocalController, this.failMode, this.datapathId, this.datapathType, this.disableInBand, this.controlProtocols);
        }

        @Override
        public Builder name(String name) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
            this.name = name;
            return this;
        }

        @Override
        public Builder controllers(List<ControllerInfo> controllers) {
            if (controllers != null) {
                this.controllers = Lists.newArrayList(controllers);
            }
            return this;
        }

        @Override
        public Builder enableLocalController() {
            this.enableLocalController = true;
            return this;
        }

        @Override
        public Builder failMode(BridgeDescription.FailMode failMode) {
            this.failMode = Optional.ofNullable(failMode);
            return this;
        }

        @Override
        public Builder datapathId(String datapathId) {
            this.datapathId = Optional.ofNullable(datapathId);
            return this;
        }

        @Override
        public Builder datapathType(String datapathType) {
            this.datapathType = Optional.ofNullable(datapathType);
            return this;
        }

        @Override
        public Builder controlProtocols(List<ControlProtocolVersion> controlProtocols) {
            this.controlProtocols = Optional.ofNullable(controlProtocols);
            return this;
        }

        @Override
        public Builder disableInBand() {
            this.disableInBand = Optional.of(Boolean.TRUE);
            return this;
        }
    }
}

