/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.device;

import org.onosproject.net.AbstractAnnotated;
import org.onosproject.net.Annotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.PortStatistics;

public final class DefaultPortStatistics
extends AbstractAnnotated
implements PortStatistics {
    private final DeviceId deviceId;
    private final PortNumber portNumber;
    private final long packetsReceived;
    private final long packetsSent;
    private final long bytesReceived;
    private final long bytesSent;
    private final long packetsRxDropped;
    private final long packetsTxDropped;
    private final long packetsRxErrors;
    private final long packetsTxErrors;
    private final long durationSec;
    private final long durationNano;

    private DefaultPortStatistics(DeviceId deviceId, PortNumber portNumber, long packetsReceived, long packetsSent, long bytesReceived, long bytesSent, long packetsRxDropped, long packetsTxDropped, long packetsRxErrors, long packetsTxErrors, long durationSec, long durationNano, Annotations annotations) {
        super(annotations);
        this.deviceId = deviceId;
        this.portNumber = portNumber;
        this.packetsReceived = packetsReceived;
        this.packetsSent = packetsSent;
        this.bytesReceived = bytesReceived;
        this.bytesSent = bytesSent;
        this.packetsRxDropped = packetsRxDropped;
        this.packetsTxDropped = packetsTxDropped;
        this.packetsRxErrors = packetsRxErrors;
        this.packetsTxErrors = packetsTxErrors;
        this.durationSec = durationSec;
        this.durationNano = durationNano;
    }

    private DefaultPortStatistics() {
        this.deviceId = null;
        this.portNumber = null;
        this.packetsReceived = 0L;
        this.packetsSent = 0L;
        this.bytesReceived = 0L;
        this.bytesSent = 0L;
        this.packetsRxDropped = 0L;
        this.packetsTxDropped = 0L;
        this.packetsRxErrors = 0L;
        this.packetsTxErrors = 0L;
        this.durationSec = 0L;
        this.durationNano = 0L;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public int port() {
        return (int)this.portNumber.toLong();
    }

    @Override
    public PortNumber portNumber() {
        return this.portNumber;
    }

    @Override
    public long packetsReceived() {
        return this.packetsReceived;
    }

    @Override
    public long packetsSent() {
        return this.packetsSent;
    }

    @Override
    public long bytesReceived() {
        return this.bytesReceived;
    }

    @Override
    public long bytesSent() {
        return this.bytesSent;
    }

    @Override
    public long packetsRxDropped() {
        return this.packetsRxDropped;
    }

    @Override
    public long packetsTxDropped() {
        return this.packetsTxDropped;
    }

    @Override
    public long packetsRxErrors() {
        return this.packetsRxErrors;
    }

    @Override
    public long packetsTxErrors() {
        return this.packetsTxErrors;
    }

    @Override
    public long durationSec() {
        return this.durationSec;
    }

    @Override
    public long durationNano() {
        return this.durationNano;
    }

    @Override
    public boolean isZero() {
        return this.bytesReceived() == 0L && this.bytesSent() == 0L && this.packetsReceived() == 0L && this.packetsRxDropped() == 0L && this.packetsSent() == 0L && this.packetsTxDropped() == 0L;
    }

    public String toString() {
        return "device: " + this.deviceId + ", port: " + this.portNumber + ", pktRx: " + this.packetsReceived + ", pktTx: " + this.packetsSent + ", byteRx: " + this.bytesReceived + ", byteTx: " + this.bytesSent + ", pktRxErr: " + this.packetsRxErrors + ", pktTxErr: " + this.packetsTxErrors + ", pktRxDrp: " + this.packetsRxDropped + ", pktTxDrp: " + this.packetsTxDropped + ", annotations: " + this.annotations();
    }

    public static final class Builder {
        DeviceId deviceId;
        PortNumber portNumber;
        long packetsReceived;
        long packetsSent;
        long bytesReceived;
        long bytesSent;
        long packetsRxDropped;
        long packetsTxDropped;
        long packetsRxErrors;
        long packetsTxErrors;
        long durationSec;
        long durationNano;
        Annotations annotations;

        private Builder() {
        }

        @Deprecated
        public Builder setPort(int port) {
            this.portNumber = PortNumber.portNumber(port);
            return this;
        }

        public Builder setPort(PortNumber portNumber) {
            this.portNumber = portNumber;
            return this;
        }

        public Builder setDeviceId(DeviceId deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder setPacketsReceived(long packets) {
            this.packetsReceived = packets;
            return this;
        }

        public Builder setPacketsSent(long packets) {
            this.packetsSent = packets;
            return this;
        }

        public Builder setBytesReceived(long bytes) {
            this.bytesReceived = bytes;
            return this;
        }

        public Builder setBytesSent(long bytes) {
            this.bytesSent = bytes;
            return this;
        }

        public Builder setPacketsRxDropped(long packets) {
            this.packetsRxDropped = packets;
            return this;
        }

        public Builder setPacketsTxDropped(long packets) {
            this.packetsTxDropped = packets;
            return this;
        }

        public Builder setPacketsRxErrors(long packets) {
            this.packetsRxErrors = packets;
            return this;
        }

        public Builder setPacketsTxErrors(long packets) {
            this.packetsTxErrors = packets;
            return this;
        }

        public Builder setDurationSec(long sec) {
            this.durationSec = sec;
            return this;
        }

        public Builder setDurationNano(long nano) {
            this.durationNano = nano;
            return this;
        }

        public Builder setAnnotations(Annotations anns) {
            this.annotations = anns;
            return this;
        }

        public DefaultPortStatistics build() {
            return new DefaultPortStatistics(this.deviceId, this.portNumber, this.packetsReceived, this.packetsSent, this.bytesReceived, this.bytesSent, this.packetsRxDropped, this.packetsTxDropped, this.packetsRxErrors, this.packetsTxErrors, this.durationSec, this.durationNano, this.annotations);
        }
    }
}

