/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiMatchFieldId;
import org.onosproject.net.pi.model.PiMatchType;
import org.onosproject.net.pi.runtime.PiFieldMatch;

@Beta
public final class PiExactFieldMatch
extends PiFieldMatch {
    private final ImmutableByteSequence value;

    public PiExactFieldMatch(PiMatchFieldId fieldId, ImmutableByteSequence value) {
        super(fieldId);
        this.value = (ImmutableByteSequence)Preconditions.checkNotNull((Object)value);
        Preconditions.checkArgument((value.size() > 0 ? 1 : 0) != 0, (Object)"Value can't have size 0");
    }

    @Override
    public PiMatchType type() {
        return PiMatchType.EXACT;
    }

    public ImmutableByteSequence value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiExactFieldMatch that = (PiExactFieldMatch)o;
        return Objects.equal((Object)((Object)this.fieldId()), (Object)((Object)that.fieldId())) && Objects.equal((Object)this.value, (Object)that.value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fieldId(), this.value});
    }

    public String toString() {
        return this.fieldId().toString() + "=" + this.value.toString();
    }
}

