/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.testing.EqualsTester;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;

public class ConnectPointTest {
    private static final DeviceId DID1 = DeviceId.deviceId((String)"1");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"2");
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final PortNumber P2 = PortNumber.portNumber((long)2L);

    private ConnectPoint cp(DeviceId d, PortNumber p) {
        return new ConnectPoint((ElementId)d, p);
    }

    @Test
    public void basics() {
        ConnectPoint p = this.cp(DID1, P2);
        Assert.assertEquals((String)"incorrect element id", (Object)DID1, (Object)p.deviceId());
        Assert.assertEquals((String)"incorrect element id", (Object)P2, (Object)p.port());
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.cp(DID1, P1), this.cp(DID1, P1)}).addEqualityGroup(new Object[]{this.cp(DID1, P2), this.cp(DID1, P2)}).addEqualityGroup(new Object[]{this.cp(DID2, P1), this.cp(DID2, P1)}).testEquals();
    }

    @Test
    public void testParseDeviceConnectPoint() {
        String cp = "of:0011223344556677/1";
        ConnectPoint connectPoint = ConnectPoint.deviceConnectPoint((String)cp);
        Assert.assertEquals((Object)"of:0011223344556677", (Object)connectPoint.deviceId().toString());
        Assert.assertEquals((Object)"1", (Object)connectPoint.port().toString());
        ConnectPointTest.expectDeviceParseException("");
        ConnectPointTest.expectDeviceParseException("1/");
        ConnectPointTest.expectDeviceParseException("1/1/1");
        ConnectPointTest.expectDeviceParseException("of:0011223344556677/word");
    }

    @Test
    public void testParseFromString() {
        String cp = "netconf:127.0.0.1/[TYPE](1)";
        ConnectPoint connectPoint = ConnectPoint.fromString((String)cp);
        Assert.assertEquals((Object)"netconf:127.0.0.1", (Object)connectPoint.deviceId().toString());
        Assert.assertEquals((Object)"[TYPE](1)", (Object)connectPoint.port().toString());
        Assert.assertEquals((Object)connectPoint, (Object)ConnectPoint.fromString((String)connectPoint.toString()));
    }

    private static void expectDeviceParseException(String string) {
        try {
            ConnectPoint.deviceConnectPoint((String)string);
            TestCase.fail((String)"Expected exception was not thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testParseHostConnectPoint() {
        String cp = "16:3A:BD:6E:31:E4/-1/1";
        ConnectPoint connectPoint = ConnectPoint.hostConnectPoint((String)cp);
        Assert.assertEquals((Object)"16:3A:BD:6E:31:E4/None", (Object)connectPoint.hostId().toString());
        Assert.assertEquals((Object)"1", (Object)connectPoint.port().toString());
        ConnectPointTest.expectHostParseException("");
        ConnectPointTest.expectHostParseException("1/");
        ConnectPointTest.expectHostParseException("1/1");
        ConnectPointTest.expectHostParseException("1/1/1/1");
        ConnectPointTest.expectHostParseException("16:3A:BD:6E:31:E4/word/1");
        ConnectPointTest.expectHostParseException("16:3A:BD:6E:31:E4/1/word");
    }

    private static void expectHostParseException(String string) {
        try {
            ConnectPoint.hostConnectPoint((String)string);
            TestCase.fail((String)"Expected exception was not thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)true);
        }
    }

    private void checkComparison(ConnectPoint cpA, Relate r, ConnectPoint cpB) {
        switch (r) {
            case BEFORE: {
                Assert.assertTrue((String)"Bad before", (cpA.compareTo(cpB) < 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)"Bad before", (cpB.compareTo(cpA) > 0 ? 1 : 0) != 0);
                break;
            }
            case SAME_AS: {
                Assert.assertTrue((String)"Bad same_as", (cpA.compareTo(cpB) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)"Bad same_as", (cpB.compareTo(cpA) == 0 ? 1 : 0) != 0);
                break;
            }
            case AFTER: {
                Assert.assertTrue((String)"Bad after", (cpA.compareTo(cpB) > 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)"Bad after", (cpB.compareTo(cpA) < 0 ? 1 : 0) != 0);
                break;
            }
            default: {
                TestCase.fail((String)"Bad relation");
            }
        }
    }

    @Test
    public void comparator() {
        this.checkComparison(this.cp(DID1, P1), Relate.SAME_AS, this.cp(DID1, P1));
        this.checkComparison(this.cp(DID1, P1), Relate.BEFORE, this.cp(DID1, P2));
        this.checkComparison(this.cp(DID1, P2), Relate.AFTER, this.cp(DID1, P1));
        this.checkComparison(this.cp(DID1, P1), Relate.BEFORE, this.cp(DID2, P1));
        this.checkComparison(this.cp(DID1, P2), Relate.BEFORE, this.cp(DID2, P1));
        this.checkComparison(this.cp(DID1, P1), Relate.BEFORE, this.cp(DID2, P2));
        this.checkComparison(this.cp(DID1, P2), Relate.BEFORE, this.cp(DID2, P2));
    }

    static enum Relate {
        BEFORE,
        SAME_AS,
        AFTER;

    }
}

