/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.device;

import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.ChassisId;
import org.onosproject.event.AbstractEventTest;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultPort;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.provider.ProviderId;

public class DeviceEventTest
extends AbstractEventTest {
    private Device createDevice() {
        return new DefaultDevice(new ProviderId("of", "foo"), DeviceId.deviceId((String)"of:foo"), Device.Type.SWITCH, "box", "hw", "sw", "sn", new ChassisId(), new Annotations[0]);
    }

    @Override
    @Test
    public void withTime() {
        Device device = this.createDevice();
        DefaultPort port = new DefaultPort((Element)device, PortNumber.portNumber((long)123L), true, new Annotations[0]);
        DeviceEvent event = new DeviceEvent(DeviceEvent.Type.DEVICE_ADDED, device, (Port)port, 123L);
        DeviceEventTest.validateEvent(event, DeviceEvent.Type.DEVICE_ADDED, device, 123L);
        Assert.assertEquals((String)"incorrect port", (Object)port, (Object)event.port());
    }

    @Override
    @Test
    public void withoutTime() {
        Device device = this.createDevice();
        DefaultPort port = new DefaultPort((Element)device, PortNumber.portNumber((long)123L), true, new Annotations[0]);
        long before = System.currentTimeMillis();
        DeviceEvent event = new DeviceEvent(DeviceEvent.Type.DEVICE_ADDED, device, (Port)port);
        long after = System.currentTimeMillis();
        DeviceEventTest.validateEvent(event, DeviceEvent.Type.DEVICE_ADDED, device, before, after);
    }
}

