/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import java.util.Set;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.OduSignalId;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.OtuSignalType;
import org.onosproject.net.TributarySlot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OduSignalUtils {
    private static final Logger log = LoggerFactory.getLogger(OduSignalUtils.class);

    private OduSignalUtils() {
    }

    public static OduSignalType mappingCltSignalTypeToOduSignalType(CltSignalType cltSignalType) {
        switch (cltSignalType) {
            case CLT_1GBE: {
                return OduSignalType.ODU0;
            }
            case CLT_10GBE: {
                return OduSignalType.ODU2;
            }
            case CLT_40GBE: {
                return OduSignalType.ODU3;
            }
            case CLT_100GBE: {
                return OduSignalType.ODU4;
            }
        }
        log.error("Unsupported CltSignalType {}", (Object)cltSignalType);
        return OduSignalType.ODU0;
    }

    public static OduSignalType mappingOtuSignalTypeToOduSignalType(OtuSignalType otuSignalType) {
        switch (otuSignalType) {
            case OTU2: {
                return OduSignalType.ODU2;
            }
            case OTU4: {
                return OduSignalType.ODU4;
            }
        }
        log.error("Unsupported OtuSignalType {}", (Object)otuSignalType);
        return OduSignalType.ODU0;
    }

    public static OduSignalId buildOduSignalId(OduSignalType oduSignalType, Set<TributarySlot> slots) {
        int tributaryPortNumber = (int)((TributarySlot)slots.stream().findFirst().get()).index();
        int tributarySlotLen = oduSignalType.tributarySlots();
        byte[] tributarySlotBitmap = new byte[10];
        slots.forEach(ts -> {
            int n = (byte)(ts.index() - 1L) / 8;
            tributarySlotBitmap[n] = (byte)(tributarySlotBitmap[n] | 1 << (int)((ts.index() - 1L) % 8L));
        });
        return OduSignalId.oduSignalId(tributaryPortNumber, tributarySlotLen, tributarySlotBitmap);
    }
}

